package com.bxm.activites.facade.service;


import com.bxm.activites.facade.constant.Constants;
import com.bxm.activites.facade.model.ActivityAwardRelationDto;
import com.bxm.activites.facade.model.ActivityDto;
import com.bxm.activites.facade.model.ActivityPositionRelationDto;
import com.bxm.activites.facade.model.ActivityStyleDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author wuwenquan on 2018/7/3.
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface ActivityBackService {

    /**
     * 保存或更新活动基本信息
     *
     * @param activityDto activity
     * @return saved
     */
    @RequestMapping(value = "/activityBackService/saveBaseActivity", method = RequestMethod.POST)
    ActivityDto saveBaseActivity(@RequestBody ActivityDto activityDto);

    /**
     * 根据活动ID删除活动样式
     *
     * @param activityId id
     */
    @RequestMapping("/activityBackService/deleteActivityStyle")
    void deleteActivityStyle(@RequestParam("activityId") Long activityId);

    /**
     * 保存活动样式
     *
     * @param activityStyleDto style
     */
    @RequestMapping(value = "/activityBackService/saveActivityStyle", method = RequestMethod.POST)
    void saveActivityStyle(@RequestBody ActivityStyleDto activityStyleDto);

    /**
     * 批量保存活动，奖品关联关系
     *
     * @param activityAwardRelationList list
     * @param activityId                id
     */
    @RequestMapping(value = "/activityBackService/saveActivityAwardRelationList/{activityId}", method = RequestMethod.POST)
    void saveActivityAwardRelationList(@RequestBody List<ActivityAwardRelationDto> activityAwardRelationList,
                                       @PathVariable("activityId") Long activityId);

    /**
     * 批量保存活动，广告位关联关系
     *
     * @param activityPositionRelationDtoList list
     * @param activityId                      id
     */
    @RequestMapping(value = "/activityBackService/saveActivityPositionRelationList/{activityId}", method = RequestMethod.POST)
    void saveActivityPositionRelationList(@RequestBody List<ActivityPositionRelationDto> activityPositionRelationDtoList,
                                          @PathVariable("activityId") Long activityId);

    /**
     * 更新活动状态
     *
     * @param activityDto activity
     */
    @RequestMapping(value = "/activityBackService/updateActivityStatus", method = RequestMethod.POST)
    void updateActivityStatus(@RequestBody ActivityDto activityDto);


    /**
     * 查询单个活动基本信息
     *
     * @param id id
     * @return activity
     * @throws Exception exceptions
     */
    @RequestMapping("/activityBackService/findActivityById")
    ActivityDto findActivityById(@RequestParam(value = "id") Long id) throws Exception;

    /**
     * 查询某个活动对应的活动，奖品关联表信息
     *
     * @param activityId id
     * @return activities
     */
    @RequestMapping("/activityBackService/findActivityAwardRelationListByActivityId")
    List<ActivityAwardRelationDto> findActivityAwardRelationListByActivityId(@RequestParam(value = "activityId") Long activityId);

    /**
     * 查询某个活动关联的广告位个数
     *
     * @param activityId id
     * @return count
     */
    @RequestMapping("/activityBackService/findActivityPositionCount")
    Integer findActivityPositionCount(@RequestParam(value = "activityId") Long activityId);

    /**
     * 查询某个活动对应的活动广告位关联表列表
     *
     * @param activityId id
     * @return relations
     */
    @RequestMapping("/activityBackService/findActivityPositionListByActivityId")
    List<ActivityPositionRelationDto> findActivityPositionListByActivityId(@RequestParam(value = "activityId") Long activityId);

    /**
     * 通过活动Id查找活动样式信息
     *
     * @param activityId id
     * @return style
     */
    @RequestMapping("/activityBackService/findActivityStyleByActivityId")
    ActivityStyleDto findActivityStyleByActivityId(@RequestParam(value = "activityId") Long activityId);

    /**
     * 查询符合查询条件的活动个数
     *
     * @param params <pre>
     *                activityId 活动Id
     *                activityName 模糊查询活动名称
     *                activityType 活动类型
     *                activityPlanner 活动策划
     *                activityDesigner 活动设计
     *                isBack          是否备用
     *                showState       显示活动状态(0,1,2;未投放，启用，停用)
     *               </pre>
     * @return count
     */
    @RequestMapping(value = "/activityBackService/findTotalCount", method = RequestMethod.POST)
    Integer findTotalCount(@RequestBody Map params);

    /**
     * 查询符合查询条件的分页活动基本信息
     *
     * @param params activityId 活动Id
     *               activityName 模糊查询活动名称
     *               activityType 活动类型
     *               activityPlanner 活动策划
     *               activityDesigner 活动设计
     *               isBack          是否备用
     *               showState       显示活动状态(0,1,2;未投放，启用，停用)
     *               offset limit  分页信息
     * @return activities
     */
    @RequestMapping(value = "/activityBackService/findActivityByPage", method = RequestMethod.POST)
    List<ActivityDto> findActivityByPage(@RequestBody Map params) throws Exception;

    /**
     * 查询某个活动关联的奖品个数
     *
     * @param activityId id
     * @return count
     */
    @RequestMapping("/activityBackService/findActivityAwardRelationCount")
    Integer findActivityAwardRelationCount(@RequestParam(value = "activityId") Long activityId);

    /**
     * 查询某个活动关联的广告位Id集合
     *
     * @param activityId id
     * @return list
     */
    @RequestMapping("/activityBackService/findActivityPositionIdList")
    List<String> findActivityPositionIdList(@RequestParam(value = "activityId") Long activityId);

    /**
     * 根据活动Id删除活动广告位关联关系
     *
     * @param activityId id
     */
    @RequestMapping("/activityBackService/deleteActivityPositionRelationByActivityId")
    void deleteActivityPositionRelationByActivityId(@RequestParam(value = "activityId") Long activityId);

    /**
     * 根据活动Id删除活动奖品关系关系
     *
     * @param activityId id
     */
    @RequestMapping("/activityBackService/deleteActivityAwardRelationByActivityId")
    void deleteActivityAwardRelationByActivityId(@RequestParam(value = "activityId") Long activityId);

    /**
     * 根据广告位Id集合绑定长常规活动
     *
     * @param positionIds ids
     */
    @RequestMapping(value = "/activityBackService/saveActivityPOsitionRelationList", method = RequestMethod.POST)
    void saveActivityPOsitionRelationList(@RequestBody List<String> positionIds);

    /**
     * 根据广告位是否匹配常规活动 删除或增加关联关系
     *
     * @param positionId positionId
     * @param flag       flag
     */
    @RequestMapping("/activityBackService/saveActivityPOsitionRelationList")
    void saveActivityPOsitionRelationList(@RequestParam("positionId") String positionId,
                                          @RequestParam("flag") Boolean flag);

    /**
     * 更改活动与广告关联表是否失效字段
     *
     * @param positionId  positionsId
     * @param activityIds ids
     */
    @RequestMapping(value = "/activityBackService/updateIsExpired/{positionId}", method = RequestMethod.POST)
    void updateIsExpired(@PathVariable("positionId") String positionId,
                         @RequestBody List<Long> activityIds);

    @RequestMapping(value = "/activityBackService/savePopupPositionRelationList", method = RequestMethod.POST)
    void savePopupPositionRelationList(@RequestBody List<String> positionIds);
}
