package com.bxm.activites.facade.service;

import com.bxm.activites.facade.constant.Constants;
import com.bxm.activites.facade.model.ActivityMsgVo;
import com.bxm.activites.facade.model.ActivityRequest;
import com.bxm.activites.facade.model.ActivityRetentionVo;
import com.bxm.activites.facade.model.PositionNewConfig;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Set;

@FeignClient(name = Constants.SERVER_NAME)
public interface ActivityBaseService {

    /**
     * @user xavier
     * @Description 校验传参
     * @date 2018/7/4
     * @param
     * @return
     */
    @RequestMapping(value = "/activityBaseService/checkRequest", method = RequestMethod.POST)
    ActivityRequest checkRequest(@RequestBody ActivityRequest activityRequest);

    /**
     * @user xavier
     * @Description 获取活动基本信息
     * @date 2018/7/4
     * @return
     */
    @RequestMapping(value = "/activityBaseService/get", method = RequestMethod.POST)
    ActivityMsgVo get(@RequestBody ActivityRequest activityRequest);

    /**
     * @user xavier
     * @Description 通过活动ID和UID获取用户该活动剩余参与次数
     * @date 2018/7/4
     * @return
     */
    @RequestMapping(value = "/activityBaseService/getTime", method = RequestMethod.POST)
    int getTime(@RequestBody ActivityRequest activityRequest);
    /**
     * @user xavier
     * @Description 添加用户活动参与次数
     * @date 2018/7/4
     * @return
     */
    @RequestMapping(value = "/activityBaseService/join", method = RequestMethod.POST)
    int join(@RequestBody ActivityRequest activityRequest);

    /**
     * 从redis中获取广告位配置信息
     * @param adPositionId
     * @date 2018/7/23
     * @return
     */
    @RequestMapping("/activityBaseService/getConfig")
    Set<String> getConfig(@RequestParam(value = "adPositionId") String adPositionId);

    @RequestMapping("/activityBaseService/getNewConfig")
    PositionNewConfig getNewConfig(@RequestParam(value = "adPositionId") String adPositionId);


    /**
     * @user xavier
     * @Description 获取挽留页
     * @date 2018/7/4
     * @return
     */
    @RequestMapping("/activityBaseService/getActivityRetention")
    ActivityRetentionVo getActivityRetention(@RequestBody ActivityRequest activityRequest);

}