package com.bxm.activites.facade.service;

import com.bxm.activites.facade.constant.Constants;
import com.bxm.activites.facade.model.ActivityConfigDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zhounan
 * created on 2018/7/25
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface ActivityConfigService {

    /**
     * 新增
     * @param activityConfigDto 对象
     * @return 0/1
     */
    @RequestMapping(value = "/activityConfigService/addProp", method = RequestMethod.POST)
    int addProp(@RequestBody ActivityConfigDto activityConfigDto);

    /**
     * 根据key获取属性值
     * @param key 属性名
     * @return 属性值
     */
    @RequestMapping("/activityConfigService/getByKey")
    String getByKey(@RequestParam(value = "key") String key);

    /**
     * 删除属性
     * @param key 属性名
     * @return 0/1
     */
    @RequestMapping("/activityConfigService/deleteByKey")
    int deleteByKey(@RequestParam(value = "key") String key);

    /**
     * 修改属性值
     * @param propKey 属性名
     * @param propValue 属性值
     * @param desc 属性描述
     * @return 0/1
     */
    @RequestMapping("/activityConfigService/saveOrUpdate")
    int saveOrUpdate(@RequestParam("propKey") String propKey,
                     @RequestParam("propValue") String propValue,
                     @RequestParam("desc") String desc);
}
