package com.bxm.activites.facade.service;

import com.bxm.activites.facade.constant.Constants;
import com.bxm.activites.facade.model.ActivityRedirectDto;
import com.bxm.activites.facade.model.AdMaterialApiVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.HashMap;
import java.util.Map;

/**
 * 活动素材服务
 *
 * @author allen
 * @since 1.0.0
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AdMaterialApiService {

    /**
     * 扩展服务，不清楚的请不要调用。
     *
     * 用于 华北2 等其他备用区域调用获取素材的服务。
     * @param adPositionId
     * @return
     */
    @RequestMapping("/adMaterialApiService/getAdMaterial")
    AdMaterialApiVo getAdMaterial(@RequestParam(value = "adPositionId") String adPositionId);

    /**
     * 扩展服务，不清楚的请不要调用。
     *
     * 用于 华北2 等其他备用区域调用统计的服务。
     * @param key
     * @return
     */
    @RequestMapping("/adMaterialApiService/increment")
    long increment(@RequestParam(value = "key") String key);

    /**
     * 获取广告位素材
     * 2018-10-11逻辑修改：先判断广告位是否有直投素材和可用直投券,有的话返回直投素材
     * @param params parameters
     * @return material entity
     * @throws Exception
     */
    @RequestMapping(value = "/adMaterialApiService/getAdMaterial", method = RequestMethod.POST)
    AdMaterialApiVo getAdMaterial(@RequestBody HashMap<String, String> params) throws Exception;

    /**
     * 获取跳转活动地址
     * @param params
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/adMaterialApiService/redirectAdUrl", method = RequestMethod.POST)
    String redirectAdUrl(@RequestBody HashMap<String, String> params) throws Exception;

    /**
     * 广告位素材曝光
     * @param adPositionId
     * @param mediaAdPositionId
     * @param adPositionMaterialId
     * @return
     */
    @RequestMapping("/adMaterialApiService/exposure")
    boolean exposure(@RequestParam("adPositionId") String adPositionId,
                     @RequestParam("mediaAdPositionId") Long mediaAdPositionId,
                     @RequestParam("adPositionMaterialId") Long adPositionMaterialId,
                     @RequestParam("ipAddress") String ipAddress);

    /**
     * 广告位素材点击
     * @param adPositionId
     * @param mediaAdPositionId
     * @param adPositionMaterialId
     * @return
     */
    @RequestMapping("/adMaterialApiService/click")
    boolean click(@RequestParam("adPositionId") String adPositionId,
                  @RequestParam("mediaAdPositionId") Long mediaAdPositionId,
                  @RequestParam("adPositionMaterialId") Long adPositionMaterialId,
                  @RequestParam("ipAddress") String ipAddress);

    /**
     * 直投素材点击
     * @param adMaterialParams
     * @return
     */
    @RequestMapping(value = "/adMaterialApiService/redirectDirectTicketUrl", method = RequestMethod.POST)
    String redirectDirectTicketUrl(@RequestBody HashMap<String,String> adMaterialParams);

    /**
     * 获取h5链接直投券
     * @param paramMap
     */
    @RequestMapping("/adMaterialApiService/getDirectTicketForH5")
    String getDirectTicketForH5(@RequestBody HashMap<String, String> paramMap);
}
