package com.bxm.activites.facade.service;



import com.bxm.activites.facade.constant.Constants;
import com.bxm.activites.facade.model.ActivityDto;
import com.bxm.activites.facade.model.AwardDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * Created by wuwenquan on 2018/7/8.
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AwardService {
     /**
      * @user wuwenquan
      * @Description 保存或更新奖品
      * @date 2018/7/16
      * @param
      * @return
      */
     @RequestMapping(value = "/awardService/saveOrUpdate", method = RequestMethod.POST)
     AwardDto saveOrUpdate(@RequestBody AwardDto awardDto);
     /**
      * @user wuwenquan
      * @Description 查询某个奖品信息
      * @date 2018/7/16
      * @param
      * @return
      */
     @RequestMapping("/awardService/findOne")
     AwardDto findOne(@RequestParam(value = "id") Long id);
     /**
      * @user wuwenquan
      * @Description 查询奖品关联的活动个数
      * @date 2018/7/16
      * @param
      * @return
      */
     @RequestMapping("/awardService/getActivityCount")
     Integer getActivityCount(@RequestParam(value = "id") Long id);
     /**
      * @user wuwenquan
      * @Description 查询符合查询条件的奖品总个数
      * @date 2018/7/16
      * @param params awrdId 奖品ID
      * @param params awardName 奖品名称
      * @return
      */
     @RequestMapping(value = "/awardService/findTotalCount", method = RequestMethod.POST)
     Integer findTotalCount(@RequestBody Map params);
     /**
      * @user wuwenquan
      * @Description 多条件分页查询奖品信息列表
      * @date 2018/7/16
      * @param params awrdId 奖品ID
      * @param params awardName 奖品名称
      * @param params offset  分页起始行
      * @param params limit  分页查询页数
      * @return
      */
     @RequestMapping(value = "/awardService/findPage", method = RequestMethod.POST)
     List<AwardDto> findPage(@RequestBody Map params);
     /**
      * @user wuwenquan
      * @Description 查询奖品关联的活动Id集合
      * @date 2018/7/16
      * @param
      * @return
      */
     @RequestMapping("/awardService/findActivityIds")
     List<Long> findActivityIds(@RequestParam(value = "id") Long id);

}
