package com.bxm.activites.facade.service;

import com.bxm.activites.facade.constant.Constants;
import com.bxm.activites.facade.model.StorageDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author allen
 * @date 2020-03-31
 * @since 1.0
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface StorageService {

    /**
     * getting storage object
     * @param slotId slot id
     * @param bizId biz id
     * @param uid uid
     * @param type type
     * @return storage
     */
    @RequestMapping("/storage/get")
    StorageDto get(@RequestParam("slotId") String slotId,
                   @RequestParam("bizId") String bizId,
                   @RequestParam("uid") String uid,
                   @RequestParam(value = "type", defaultValue = "1") Integer type);

    /**
     * save the storage object
     * @param storageDto dto
     */
    @PutMapping("/storage/save")
    void save(@RequestBody StorageDto storageDto);
}
