package com.bxm.activites.facade.service;

import com.bxm.activites.facade.constant.Constants;
import com.bxm.activites.facade.model.ActivityRequestDto;
import com.bxm.activites.facade.model.InfoActivity;
import com.bxm.activites.facade.model.WeightEntry;
import com.bxm.activites.facade.model.branchflow.BranchFlow;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * <h3>Activity Service</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/20
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface ActivityService {

    
    /**  
	 * @Title: getActMsg  
	 * @Description:  获取活动信息
	 * @author xavier  
	 * @throws Exception 
	 * @date 2018年5月9日
	 */
    @RequestMapping("/activityService/getActMsg")
    InfoActivity getActMsg(@RequestParam("actId") String actId);
	
	/**  
	 * @Title: getActMsg  
	 * @Description:  获取活动信息MAP
	 * @author xavier  
	 * @date 2018年5月9日
	 */
	@RequestMapping("/activityService/getBizActMsg")
	Map<Long, Double> getBizActMsg(@RequestParam("positionId") String positionId);

	/**
	 * 获取人均点击
	 * @param positionId
	 * @param dafaultView
	 * @param defaultRepeatClicks
	 * @param  activityIdFactor 活动ID及人工系数
	 * @return
	 */
	@RequestMapping(value = "/activityService/getPerClick/{positionId}/{dafaultView}/{defaultRepeatClicks}", method = RequestMethod.POST)
	List<WeightEntry>  getPerClick(@PathVariable("positionId") String positionId,
								   @PathVariable("dafaultView") String dafaultView,
								   @PathVariable("defaultRepeatClicks") String defaultRepeatClicks,
								   @RequestBody Map<Integer, Integer> activityIdFactor);

	/***
	 * 获取活动在广告位下历史uv数据，筛选阈值以下活动列表
	 * @param activityIdFactor
	 * @param positionId
	 * @param dafaultView uv阈值
	 * @return
	 */
	@RequestMapping(value = "/activityService/getActivityWeightUnderThreshold/{positionId}/{dafaultView}", method = RequestMethod.POST)
    List<WeightEntry> getActivityWeightUnderThreshold(@RequestBody Map<Integer, Integer> activityIdFactor,
													  @PathVariable("positionId") String positionId,
													  @PathVariable("dafaultView") int dafaultView);

    /**
	 *
	 * @param positionId
	 * @param  activityIdFactor 活动id对应人工系数Map
	 * @return
	 */
	@RequestMapping(value = "/activityService/getPerClick/{positionId}", method = RequestMethod.POST)
	List<WeightEntry>  getPerClick(@PathVariable("positionId") String positionId,
								   @RequestBody Map<Integer, Integer> activityIdFactor);

	/**
	 * @Title: getActivity
	 * @Description:  根据用户和positionId 获取活动信息
	 * @author xavier
	 * @date 2018年5月15日
	 */
	@RequestMapping("/activityService/getActivity")
	InfoActivity getActivity(@RequestParam("uid") String uid,
							 @RequestParam("positionId") String positionId);

	/**
	 * 扣减活动奖品库存，扣减单位为1
	 * @param activityId
	 * @param awardId
	 * @return
	 */
	@RequestMapping("/activityService/subAwardAmount")
	Boolean subAwardAmount(@RequestParam("activityId") Long activityId,
						   @RequestParam("awardId") Long awardId);

	/**
	 * 增加活动奖品库存（回滚使用）
	 * @param activityId
	 * @param awardId
	 * @return
	 */
	@RequestMapping("/activityService/addAwardAmount")
	Boolean addAwardAmount(@RequestParam("activityId") Long activityId,
						   @RequestParam("awardId") Long awardId);

	/**
	 * 获取所有广告位对应的活动数量
	 * @return
	 */
	@RequestMapping("/activityService/getPositionActivityCount")
	Map<String,Integer> getPositionActivityCount();

	/**
	 *
	 * @param positionId
	 * @param activityIdFactor 活动id对应人工系数Map
	 * @return
	 */
	@RequestMapping(value = "/activityService/getPerClickNew/{positionId}", method = RequestMethod.POST)
	List<WeightEntry> getPerClickNew(@PathVariable("positionId") String positionId,
									 @RequestBody Map<Integer,Integer> activityIdFactor);


	/**
	 * 获取历史人均券点击
	 * @param positionId
	 * @param activityId
	 * @return
	 */
	@RequestMapping("/activityService/getTotalPerClick")
	double getTotalPerClick(@RequestParam("positionId") String positionId,
							@RequestParam("activityId") Integer activityId);

	/**
	 * 获取活动在广告位下的历史uv
	 * @param positionId
	 * @param activityId
	 * @return
	 */
	@RequestMapping("/activityService/getTotalUv")
	long getTotalUv(@RequestParam("positionId") String positionId,
					@RequestParam("activityId") Integer activityId);

    /**
     * 获取活动
     * @param dto
     * @return
     */
    @RequestMapping("/activityService/getActivity2")
    InfoActivity getActivity2(@RequestBody ActivityRequestDto dto);

	/**
	 * 获取活动
	 * @param dto
	 * @return
	 */
	@RequestMapping("/activityService/getActivityV4")
	InfoActivity getActivityV4(@RequestBody ActivityRequestDto dto);

	/**
	 * @Title:
	 * @Description:  获取活动信息流量比例V4
	 * @author xavier
	 * @date 2018年5月9日
	 */
	@RequestMapping("/activityService/getBizActMsgV4")
	List<BranchFlow> getBizActMsgV4(@RequestParam("positionId") String positionId);
}
