package com.bxm.activites.facade.service;

import com.bxm.activites.facade.constant.Constants;
import com.bxm.activites.facade.model.PopupVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = Constants.SERVER_NAME)
public interface PopupService {
	
	/**
	 * 依据CTR值
	 * 根据广告位获取广告位下面的 首页弹窗、挽留弹窗
	 * @param position
	 * @param type 弹窗类型
	 * @return 首页弹窗、挽留弹窗
	 */
	@RequestMapping("/popupService/getPopupByPosition")
	PopupVo getPopupByPosition(@RequestParam("position") String position,
							   @RequestParam("type") Integer type);

	/**
	 * 获取活动配置的弹窗，
	 * 根据广告位下各弹窗CTR值获取弹窗信息
	 * @param position 广告位
	 * @param activityId 活动ID
	 * @param type 类型
	 * @return 出券弹窗或者null
	 */
	@RequestMapping("/popupService/getTicketPopupByPostionAndActivityId")
	PopupVo getTicketPopupByPostionAndActivityId(@RequestParam("position") String position,
												 @RequestParam("activityId") Long activityId,
												 @RequestParam("type") Integer type);

	/**
	 * 依据参与率获取广告位下面的挽留弹窗
	 * @param position 广告位
	 * @param usedPopupIds 已经出过的弹窗
	 * @return 首页弹窗、挽留弹窗
	 */
	@RequestMapping("/popupService/getStayPopupByPosition")
	PopupVo getStayPopupByPosition(@RequestParam("positionId") String positionId,
								   @RequestParam("usedPopupIds") String usedPopupIds);


    @RequestMapping("/popupService/getPopupsByPopupIds")
    List<PopupVo> getPopupsByPopupIds(@RequestParam("popupIds") String popupIds) throws Exception;
}
