package com.bxm.activites.facade.service;

import com.bxm.activites.facade.constant.Constants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author zhounan
 * created on 2018/7/23
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface PositionConfigBackService {

    /**
     * 是否匹配常规活动
     *
     * @param positionId 广告位id
     * @param matched    是否匹配常规活动
     * @return 0/1
     */
    @RequestMapping("/positionConfigBackService/updateMathed")
    int updateMathed(@RequestParam("positionId") String positionId,
                     @RequestParam("matched") Integer matched);

    /**
     * 匹配常规活动的广告位集合
     *
     * @return 广告位id集合
     */
    @RequestMapping("/positionConfigBackService/listByMatched")
    List<String> listByMatched();


    /**
     * 获取广告位是否匹配常规活动状态
     * @param positionId 广告位id
     * @return 匹配状态
     */
    @RequestMapping("/positionConfigBackService/getMatchedByPositionId")
    Integer getMatchedByPositionId(@RequestParam(value = "positionId") String positionId);

}
