package com.bxm.activitiesprod.common.generator;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**  
* @Title: TicketKeyGenerator 
* @Description:  活动相关KEY的创建
* @author xavier  
* @date 2018年5月13日  
*/  
public final class
ActivityKeyGenerator {

    //用户默认抽奖次数
    public static final int DEFAULT_TIMES = 8;

    public static class Filter {
        private Filter() {}

        public static KeyGenerator getTmpPostion6H() {
            return () -> KeyBuilder.build("AD", "TEMP", "POSITIONS", "6H");
        }

        public static KeyGenerator getCountMidPv(String positionId,String date,String activityId) {
            return () -> KeyBuilder.build("AD", "COUNTER", "ACTIVITY", "MID", activityId,positionId ,date);
        }

        public static KeyGenerator getCountAct2H(Integer actId) {
        	return () -> KeyBuilder.build("AD", "COUNTER", "ACTIVITY", "2H", actId);
        }
        
        public static KeyGenerator getCountAct24H(Integer actId) {
        	return () -> KeyBuilder.build("AD", "COUNTER", "ACTIVITY", "24H", actId);
        }

        public static KeyGenerator getCountActAllUv(Integer actId, String positionId) {
        	return () -> KeyBuilder.build("AD", "COUNTER", "ACTIVITY", "ALL", "UV", actId, positionId);
        }

        public static KeyGenerator getCountActAllClick(Integer actId, String positionId) {
        	return () -> KeyBuilder.build("AD", "COUNTER", "ACTIVITY", "ALL", "CLICK", actId, positionId);
        }

        public static KeyGenerator getUserJoinInfo(String uid) {
            return () -> KeyBuilder.build("AD", "COUNT", "ACTIVITY", "JOIN", "INFO", uid);
        }

        public static KeyGenerator getActDefaultNum() {
        	return () -> KeyBuilder.build("AD", "ACTIVITY", "DEFAULT", "NUM");
        }

        public static KeyGenerator getActDefaultRepeat() {
        	return () -> KeyBuilder.build("AD", "ACTIVITY", "DEFAULT", "REPEAT");
        }

        public static KeyGenerator getActRandomMsg(String positionId) {
        	return () -> KeyBuilder.build("AD", "ACTIVITY", "RANDOM", "MSG", positionId);
        }

        public static KeyGenerator getActDefaultMsg() {
        	return () -> KeyBuilder.build("AD", "ACTIVITY", "DEFAULT", "MSG");
        }

        public static KeyGenerator getActBasicInfo() {
        	return () -> KeyBuilder.build("AD", "ACTIVITY", "BASIC", "INFO");
        }

        public static KeyGenerator getActAwardInfo() {
            return () -> KeyBuilder.build("AD", "ACTIVITY", "AWARD", "INFO");
        }

        public static KeyGenerator getActDefaultId() {
        	return () -> KeyBuilder.build("AD", "ACTIVITY", "DEFAULT", "ID");
        }
        
    }
    
    public static class User {
        private User() {}

        public static KeyGenerator getUserActRecord(String uid) {
        	return () -> KeyBuilder.build("AD", "ACTIVITY", "USER", "RECORD", uid);
        }
    }
}
