package com.bxm.activitiesprod.common.generator;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

/**
 * redis相关操作，key设定
 * @author zhiwen.li
 *
 */
public class RedisKeyGenerator {
   
   /**
    * 弹窗操作相关key设定
    * @author zhiwen.li
    *
    */
   public static class Popup{
	   
	   //指定弹窗DB
	   public static int selector = 3;
	   
	   private Popup() {}
	   
	   /**获取弹窗实体类信息 hash结构 field:tabldId value:PopupRedisSo实体**/
	   public static KeyGenerator gePopupRedisSoKey() {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "POPUP","SO");
       }
	   /**获取弹窗关联广告位信息 hash结构 field:tabldId value:List<postionId>实体**/
	   public static KeyGenerator gePopupPostionRelationKey() {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "POPUP","RELATION");
       }
	   /**获取广告位弹窗的权重值SortedSet结构 member:tabldId score:该弹窗在该广告位的默认点击率CTR值**/
	   public static KeyGenerator gePopupPostionCTRKey(String Type,String positionId) {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "POPUP","CTR",Type,positionId);
       }
	   /**获取广告位弹窗的点击值hash结构 field: ${弹窗} value:对应点击值**/
	   public static KeyGenerator gePopupPostionDJKey(String Type,String positionId) {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "POPUP","CLICK",Type,positionId);
       }
	   
	   /**获取广告位弹窗的曝光值hash结构 field: ${弹窗} value:对应曝光值**/
	   public static KeyGenerator gePopupPostionBGKey(String Type,String positionId) {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "POPUP","VIEW",Type,positionId);
       }
	   
	   /**根据弹窗类型记录下面有哪些弹窗 set结构 member:${弹窗}**/
	   public static KeyGenerator gePopupPostionTypeKey(String Type) {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "POPUP","TYPE",Type);
       }

       /**根据活动ID 关联弹窗 通过活动类型转换**/
       public static KeyGenerator getActivityIdPopupRelationByType(){
           return () -> KeyBuilder.build("AD", "ACTIVITY", "POPUP","RELATION","TYPE");
       }

       /**根据活动ID 关联弹窗 通过活动ID直接关联**/
       public static KeyGenerator getActivityIdPopupRelationById(){
           return () -> KeyBuilder.build("AD", "ACTIVITY", "POPUP","RELATION","ID");
       }

       /**根据活动ID 关联弹窗 结合ID和类型 前端查询使用**/
       public static KeyGenerator getActivityIdPopupRelationAll(){
           return () -> KeyBuilder.build("AD", "ACTIVITY", "POPUP","RELATION","ALL");
       }

       /**根据活动类型 关联弹窗关联**/
       public static KeyGenerator getActivityTypePopupRelation(){
           return () -> KeyBuilder.build("AD", "ACTIVITY","TYPE", "POPUP","RELATION");
       }

       /**根据活动类型 关联活动ID **/
       public static KeyGenerator getActivityTypeActivityIdRelation(){
           return () -> KeyBuilder.build("AD", "ACTIVITY","TYPE", "ACTIVITY","ID","RELATION");
       }

       /**根据活动ID 关联活动类型 hash **/
       public static KeyGenerator getActivityIdTypeRelation(){
           return () -> KeyBuilder.build("AD", "ACTIVITY","ID","TYPE","RELATION");
       }
	   
   }

   public static class Activity{
       public static int selector = 3;
       /**广告位id列表6小时缓存key**/
       public static KeyGenerator getTmpPostion6H() {
           return () -> KeyBuilder.build("AD", "TEMP", "POSITIONS", "6H");
       }

       /**活动阈值，用来计算权重时活动点击UV是否达到阈值**/
       public static KeyGenerator getActDefaultNum() {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "DEFAULT", "NUM");
       }

       /**活动默认人均点击，用来给新活动启动，缓存key**/
       public static KeyGenerator getActDefaultRepeat() {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "DEFAULT", "REPEAT");
       }

       /**广告位定向活动hash缓存key**/
       public static KeyGenerator getActRandomMsg(String positionId) {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "RANDOM", "MSG", positionId);
       }

       /**旧的活动基本信息缓存，目前只用来保存活动抽奖次数**/
       public static KeyGenerator getActBasicInfo() {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "BASIC", "INFO");
       }

       /**活动基本信息缓存**/
       public static KeyGenerator getActBasicMsg(Long activityId) {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "BASIC", "MSG", activityId);
       }

       /**默认活动id，写死的缓存key**/
       public static KeyGenerator getActDefaultId() {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "DEFAULT", "ID");
       }

       public static KeyGenerator getCountAct2H(Integer actId) {
           return () -> KeyBuilder.build("AD", "COUNTER", "ACTIVITY", "2H", actId);
       }

       public static KeyGenerator getCountAct24H(Integer actId) {
           return () -> KeyBuilder.build("AD", "COUNTER", "ACTIVITY", "24H", actId);
       }

       public static KeyGenerator getCountActAllUv(Integer actId, String positionId) {
           return () -> KeyBuilder.build("AD", "COUNTER", "ACTIVITY", "ALL", "UV", actId, positionId);
       }

       public static KeyGenerator getCountActAllClick(Integer actId, String positionId) {
           return () -> KeyBuilder.build("AD", "COUNTER", "ACTIVITY", "ALL", "CLICK", actId, positionId);
       }

       /**活动奖项列表缓存key**/
       public static KeyGenerator getActivityAwardMsg(Long activityId) {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "AWARD", "MSG", activityId);
       }

       /**活动样式缓存key**/
       public static KeyGenerator getActivityStyle(Long activityId) {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "STYLE", activityId);
       }

       /**获取用户活动记录**/
       public static KeyGenerator getUserActRecord(String uid) {
           return () -> KeyBuilder.build("AD", "ACTIVITY", "USER", "RECORD", uid);
       }




   }
   
}
