package com.bxm.activitiesprod.common.utils;

import com.bxm.activitiesprod.common.generator.RedisKeyGenerator;
import com.bxm.warcar.cache.Fetcher;
import com.bxm.warcar.cache.Updater;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 活动与弹窗关联
 * @author bcc
 */
public final class ActivityPopupRelationUtils {
    private ActivityPopupRelationUtils(){}

    public static void addActivityByActivityType(String popupId, String activityType, Fetcher fetcher, Updater updater) {
        //活动类型与弹窗关联hash
        List<String> popupIds = fetcher.hfetchListWithSelector(RedisKeyGenerator.Popup.getActivityTypePopupRelation(), activityType, String.class,RedisKeyGenerator.Popup.selector);
        popupIds = addToList(popupId, popupIds);
        updater.hupdateWithSelector(RedisKeyGenerator.Popup.getActivityTypePopupRelation(),activityType, popupIds,RedisKeyGenerator.Popup.selector);

        //活动类型获取对应所有活动ID
        List<String> activityIds2 = fetcher.hfetchListWithSelector(RedisKeyGenerator.Popup.getActivityTypeActivityIdRelation(), activityType, String.class,RedisKeyGenerator.Popup.selector);
        if(CollectionUtils.isNotEmpty(activityIds2)) {
            if (CollectionUtils.isNotEmpty(activityIds2)) {
                for (String activityId : activityIds2) {
                    addActivityPopupRelation(activityId, popupId, fetcher, updater,Boolean.FALSE,Boolean.TRUE);
                }
            }
        }
    }

    public static List<String> addToList(String popupId, List<String> popupIds) {
        if(null == popupIds){
            popupIds = new ArrayList<>();
            popupIds.add(popupId);
        }else if(!popupIds.contains(popupId)){
            popupIds.add(popupId);
        }
        return popupIds;
    }

    /**
     * 增加活动ID与弹窗ID关联
     * @param activityId
     * @param popupId
     * @param fetcher
     * @param updater
     */
    public static void addActivityPopupRelation( String activityId,String popupId, Fetcher fetcher, Updater updater,Boolean addById,Boolean addByType) {
        List<String> popupIds = fetcher.hfetchListWithSelector(RedisKeyGenerator.Popup.getActivityIdPopupRelationById(), activityId, String.class, RedisKeyGenerator.Popup.selector);
        if(null == popupIds){
           popupIds = new ArrayList<>();
        }
        if(addById) {
            //修改活动ID与弹窗ID关联
            popupIds = addToList(popupId, popupIds);
            updater.hupdateWithSelector(RedisKeyGenerator.Popup.getActivityIdPopupRelationById(), activityId, popupIds, RedisKeyGenerator.Popup.selector);
        }
        List<String> popupIds2 = fetcher.hfetchListWithSelector(RedisKeyGenerator.Popup.getActivityIdPopupRelationByType(), activityId, String.class, RedisKeyGenerator.Popup.selector);
        if(null == popupIds2){
            popupIds2 = new ArrayList<>();
        }
        if(addByType){
            //修改活动Type与弹窗ID关联
            popupIds2 = addToList(popupId, popupIds2);
            updater.hupdateWithSelector(RedisKeyGenerator.Popup.getActivityIdPopupRelationByType(), activityId, popupIds2, RedisKeyGenerator.Popup.selector);
        }
        //取并集
        popupIds.removeAll(popupIds2);
        popupIds2.addAll(popupIds);
        updater.hupdateWithSelector(RedisKeyGenerator.Popup.getActivityIdPopupRelationAll(), activityId, popupIds2, RedisKeyGenerator.Popup.selector);

    }

    /**
     * 删除活动与弹窗关联
     * @param activityId
     * @param popupId
     * @param fetcher
     * @param updater
     */
    public static void deleteActivityPopupRelation(String activityId,String popupId,Fetcher fetcher , Updater updater,Boolean deleteById,Boolean deleteByType) {
        //删除ID关联
        List<String> popupIds = fetcher.hfetchListWithSelector(RedisKeyGenerator.Popup.getActivityIdPopupRelationById(), activityId, String.class, RedisKeyGenerator.Popup.selector);
        if(null == popupIds){
            popupIds = new ArrayList<>();
        }
        if(deleteById) {
            if (CollectionUtils.isNotEmpty(popupIds)) {
                popupIds.remove(popupId);
                updater.hupdateWithSelector(RedisKeyGenerator.Popup.getActivityIdPopupRelationById(), activityId, popupIds, RedisKeyGenerator.Popup.selector);
            }
        }

        List<String> popupIds2 = fetcher.hfetchListWithSelector(RedisKeyGenerator.Popup.getActivityIdPopupRelationByType(), activityId, String.class, RedisKeyGenerator.Popup.selector);
        if(null == popupIds2){
            popupIds2 = new ArrayList<>();
        }
        //删除类型关联
        if(deleteByType) {
            if (CollectionUtils.isNotEmpty(popupIds2)) {
                popupIds2.remove(popupId);
                updater.hupdateWithSelector(RedisKeyGenerator.Popup.getActivityIdPopupRelationByType(), activityId, popupIds2, RedisKeyGenerator.Popup.selector);
            }
        }
        //取并集
        popupIds.removeAll(popupIds2);
        popupIds2.addAll(popupIds);
        updater.hupdateWithSelector(RedisKeyGenerator.Popup.getActivityIdPopupRelationAll(), activityId, popupIds2, RedisKeyGenerator.Popup.selector);
    }
}
