package com.bxm.activitiesprod.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Random;
import java.util.Set;

/**  
* @Title: RandomUtils 
* @Description:  随机数
* @author xavier  
* @date 2018年5月9日  
*/  
public class ActivityRandomUtils {
	
	/**  
	 * @Title: getActByRate  
	 * @Description:  在map中获取随机一个随机数，重组MAP
	 * @author xavier  
	 * @date 2018年5月9日
	 */  
	public static Integer getKeyByRate(Map<Integer, Integer> msg){
		Map<Integer, String> map = new HashMap<>();
		int sum = 0;
		Set<Entry<Integer, Integer>> entries = msg.entrySet();
		for (Entry<Integer, Integer> entry : entries) {
			Integer key = entry.getKey();
			int value = msg.get(key) + sum;
			map.put(key, sum + "-" + value);
			sum = value + 1;
		}
		//计算概率
		return getLotteryLevel(map, sum);
	}

	/**  
	 * @Title: getLotteryLevel  
	 * @Description:  在map中获取随机一个随机数，实现
	 * @author xavier  
	 * @date 2018年5月9日
	 */  
	public static Integer getLotteryLevel(Map<Integer, String> map, Integer total) {
        Random random = new Random(System.nanoTime());
        if (total == 0) {
            total = 1;
        }
        Integer randNum = Math.abs(random.nextInt()) % total;
        if (randNum == 0) {
            randNum = 1;
        }
        for (Entry<Integer, String> it : map.entrySet()) {
            String[] str = it.getValue().split("-");
            Integer start = Integer.valueOf(str[0]);
            Integer end = Integer.valueOf(str[1]);
            if (randNum >= start && randNum <= end) {
                return it.getKey();
            } else {
                continue;
            }
        }
        return -1;
    }
	
}
