/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.activitiesprod.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.springframework.cglib.beans.BeanCopier;

public class BeanUtil {
    private static ConcurrentMap<Class, ConcurrentMap<Class, BeanCopier>> beanCopierMap = new ConcurrentHashMap<Class, ConcurrentMap<Class, BeanCopier>>();

    public static Object copy(Object src, Object dest) {
        BeanCopier beanCopier;
        if (src == null) {
            return null;
        }
        if (dest == null) {
            throw new NullPointerException("dest is null");
        }
        ConcurrentMap<Class<?>, BeanCopier> innerMap = (ConcurrentHashMap)beanCopierMap.get(src.getClass());
        if (innerMap == null) {
            innerMap = new ConcurrentHashMap();
            ConcurrentMap temp = beanCopierMap.putIfAbsent(src.getClass(), innerMap);
            if (temp != null) {
                innerMap = temp;
            }
        }
        if ((beanCopier = (BeanCopier)innerMap.get(dest.getClass())) == null) {
            beanCopier = BeanCopier.create(src.getClass(), dest.getClass(), (boolean)false);
            BeanCopier temp = innerMap.putIfAbsent(dest.getClass(), beanCopier);
            if (temp != null) {
                beanCopier = temp;
            }
        }
        beanCopier.copy(src, dest, null);
        return dest;
    }

    public static <T> T copy(Object src, Class<T> destClass) {
        if (src == null) {
            return null;
        }
        try {
            T dest = destClass.newInstance();
            BeanUtil.copy(src, dest);
            return dest;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> copyList(List<?> srcList, Class<T> destClass) {
        if (srcList == null) {
            return Collections.emptyList();
        }
        ArrayList<T> retList = new ArrayList<T>();
        for (Object src : srcList) {
            T destInstance = BeanUtil.copy(src, destClass);
            retList.add(destInstance);
        }
        return retList;
    }

    public static Map<String, Object> transBeanToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            map = new HashMap();
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.equals("class")) continue;
                Method getter = property.getReadMethod();
                Object value = getter.invoke(obj, new Object[0]);
                map.put(key, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static <K, E> Map<K, E> transf(List<E> list, Function<E, K> t) {
        HashMap map = Maps.newHashMap();
        for (E e : list) {
            map.put(t.apply(e), e);
        }
        return map;
    }

    public static <K, E> List<K> getParam(List<E> list, Function<E, K> t) {
        ArrayList result = Lists.newArrayList();
        for (E e : list) {
            K k = t.apply(e);
            if (k == null) continue;
            result.add(k);
        }
        return result;
    }
}

