/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.activitiesprod.common.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtils {
    public static ThreadLocalRandom getRandom() {
        return ThreadLocalRandom.current();
    }

    public static int getRandomInt(int max) {
        return RandomUtils.getRandom().nextInt(max);
    }

    public static int getRandomInt(int min, int max) {
        return RandomUtils.getRandom().nextInt(max - min + 1) + min;
    }

    public static long getRandomLong(long max) {
        return RandomUtils.getRandom().nextLong(max);
    }

    public static <E> E getRandomElement(E[] array) {
        return array[RandomUtils.getRandomInt(array.length)];
    }

    public static <E> E getRandomElement(List<E> list) {
        return list.get(RandomUtils.getRandomInt(list.size()));
    }

    public static <E> E getRandomElement(Set<E> set) {
        int rn = RandomUtils.getRandomInt(set.size());
        int i = 0;
        for (E e : set) {
            if (i == rn) {
                return e;
            }
            ++i;
        }
        return null;
    }

    public static <K, V> K getRandomKeyFromMap(Map<K, V> map) {
        int rn = RandomUtils.getRandomInt(map.size());
        int i = 0;
        for (K key : map.keySet()) {
            if (i == rn) {
                return key;
            }
            ++i;
        }
        return null;
    }

    public static <K, V> V getRandomValueFromMap(Map<K, V> map) {
        int rn = RandomUtils.getRandomInt(map.size());
        int i = 0;
        for (V value : map.values()) {
            if (i == rn) {
                return value;
            }
            ++i;
        }
        return null;
    }
}

