/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.dal.ad_api_material.mapper.ext;

import java.util.List;

import com.bxm.adapi.dal.ad_api_material.model.AdPositionMaterialDo;
import com.bxm.adapi.model.bo.AdPositionMaterialBo;
import org.apache.ibatis.annotations.Param;

import com.bxm.adapi.dal.ad_api_material.mapper.AdPositionMaterialDoMapper;
import com.bxm.adapi.facade.model.AdPositionMaterialDto;

/**
 * @ClassName AdPositionMaterialDoMapperExt.java
 * @Description 功能描述：
 * @author leon 2018年3月23日 下午3:33:52
 * @CopyRight 杭州微财网络科技有限公司
 */
public interface AdPositionMaterialDoMapperExt extends AdPositionMaterialDoMapper {

    /**
     * @Description 方法描述：查询列表
     * @author leon 2018年3月23日 下午3:34:12
     * @CopyRight 杭州微财网络科技有限公司
     * @param adPositionMaterialDto
     * @return
     */
    List<AdPositionMaterialBo> getHistoryMaterialCtr(AdPositionMaterialDto adPositionMaterialDto);

    List<AdPositionMaterialBo> getTodayMaterialCtr(AdPositionMaterialDto adPositionMaterialDto);

    /**
     * @Description 方法描述：修改状态
     * @author leon 2018年3月24日 下午4:27:36
     * @CopyRight 杭州微财网络科技有限公司
     * @param ids
     * @param status
     * @return
     */
    int updateStatus(@Param("id") Long id, @Param("status") Integer status);

    /**
     * 查询广告位以及素材信息
     * @param id
     * @return
     */
    AdPositionMaterialBo selectInfoById(@Param("id") Long id);

    Boolean updateHistoryCtr(@Param("historyCtr") Double historyCtr, @Param("id") Long id);

    /**
     * 根据广告位id查询列表
     * @param id
     * @return
     */
    List<AdPositionMaterialDo> selectByAdId(@Param("id") Long id);

    List<AdPositionMaterialDo> selectBlockByIdSection(@Param("startId") long startId, @Param("endId") Long endId);
}
