/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.dal.ad_api_material.mapper.ext;

import java.util.List;

import com.bxm.adapi.model.bo.LastCtrInfoBo;
import org.apache.ibatis.annotations.Param;

import com.bxm.adapi.dal.ad_api_material.mapper.AdapiMediaAdPositionExposureClickDoMapper;
import com.bxm.adapi.dal.ad_api_material.model.AdapiMediaAdPositionExposureClickDo;

/**
 * @ClassName AdapiMediaAdPositionExposureClickDoMapperExt.java
 * @Description 功能描述：
 * @author leon 2018年4月2日 上午11:01:32
 * @CopyRight 杭州微财网络科技有限公司
 */
public interface AdapiMediaAdPositionExposureClickDoMapperExt extends AdapiMediaAdPositionExposureClickDoMapper {

    /**
     * @Description 方法描述：根据媒体广告位id查询列表
     * @author leon 2018年3月31日 下午12:40:57
     * @CopyRight 杭州微财网络科技有限公司
     * @param mediaAdPositionId
     * @return
     */
    List<AdapiMediaAdPositionExposureClickDo> getListByMediaAdPositionId(@Param("mediaAdPositionId") Long mediaAdPositionId);

    /**
     * @Description 方法描述：根据媒体广告位id查询列表
     * @author leon 2018年3月31日 下午12:40:57
     * @CopyRight 杭州微财网络科技有限公司
     * @return
     */
    List<LastCtrInfoBo> getListByMediaAdPositionIds(@Param("mediaAdPositionIds") List<Long> mediaAdPositionIds);

    /**
     * @Description 方法描述：根据媒体广告位id修改
     * @author leon 2018年3月31日 下午1:24:56
     * @CopyRight 杭州微财网络科技有限公司
     * @param adapiMediaAdPositionExposureClickDo
     * @return
     */
    int updateByMediaAdPositionId(AdapiMediaAdPositionExposureClickDo adapiMediaAdPositionExposureClickDo);

    /**
     * @Description 方法描述：根据媒体广告位id删除
     * @author leon 2018年3月31日 下午12:40:57
     * @CopyRight 杭州微财网络科技有限公司
     * @param mediaAdPositionId
     * @return
     */
    int deleteByMediaAdPositionIdAndAdPositionMaterialId(@Param("mediaAdPositionId") Long mediaAdPositionId);
}
