/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.dal.ad_api_material.mapper.ext;

import com.bxm.adapi.dal.ad_api_material.base.BaseMapper;
import com.bxm.adapi.dal.ad_api_material.model.MediaAdPositionDo;
import com.bxm.adapi.facade.model.MediaAdPositionDto;
import com.bxm.adapi.facade.model.MediaAdPositionRo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @ClassName MediaAdPositionDoMapperExt.java
 * @Description 功能描述：
 * @author leon 2018年3月23日 下午3:32:54
 * @CopyRight 杭州微财网络科技有限公司
 */
public interface MediaAdPositionDoMapperExt extends BaseMapper<MediaAdPositionDo> {

    /**
     * @Description 方法描述：根据条件查询广告位历史点击信息列表
     * @author yirj
     * @CopyRight 杭州微财网络科技有限公司
     * @return
     */
    List<MediaAdPositionRo> getHistoryCtrInfo(MediaAdPositionDto mediaAdPositionDto);

    /**
     * @Description 方法描述：根据条件查询广告位当天点击信息列表
     * @author yirj
     * @CopyRight 杭州微财网络科技有限公司
     * @return
     */
    List<MediaAdPositionRo> getTodayCtrInfo(MediaAdPositionDto mediaAdPositionDto);

    /**
     * @Description 方法描述： 批量逻辑删除
     * @author leon 2017年11月15日 下午3:15:12
     * @CopyRight 杭州微财网络科技有限公司
     * @param ids
     * @return
     */
    int deletes(@Param("ids") List<Long> ids);

    /**
     * @Description 方法描述： 根据广告位修改媒体信息
     * @author leon 2018年3月28日 下午4:29:04
     * @CopyRight 杭州微财网络科技有限公司
     * @param mediaAdPositionDo
     * @return
     */
    int updateByAdPositionId(MediaAdPositionDo mediaAdPositionDo);

    @Select("select ad_position_id from media_ad_position where id=#{id}")
    String queryAdPositionIdById(@Param("id") Long id);

    String queryAdPositionIdByAdMaterialId(@Param("adPositionMaterialId") Long adPositionMaterialId);

    /**
     * 更新广告位历史点击率,根据广告位每日统计总和算出
     * @return
     */
    Boolean updateHistoryCtrByAdId(@Param("adId") Long id);

    /**
     * 分片查询数据
     *
     * @return
     */
    List<MediaAdPositionDo> selectByBlockId(@Param("startId") long startId, @Param("endId") long endId);

    /**
     * 查询未被删除的的最大的id
     * @return
     */
    Long selectValidLastId();

    /**
     * 根据广告位列表查询尺寸
     * @return
     */
    List<MediaAdPositionDo> querySizesByAdPositionIds(@Param("adPositionIds") List<String> adPositionIds);
}
