package com.bxm.adapi.dal.ad_api_material.model;

import com.bxm.adapi.dal.ad_api_material.base.BaseEntity;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Table;
import java.util.Date;

@Getter
@Setter
@Table(name = "adapi_ad_position_material_ctr")
public class AdapiAdPositionMaterialCtrDo extends BaseEntity {

    @Column(name = "media_ad_position_id")
    private Long mediaAdPositionId; // 媒体&广告位id

    @Column(name = "ad_position_material_id")
    private Long adPositionMaterialId; // 广告位素材id

    @Column(name = "calc_cycle")
    private Long calcCycle; // 计算周期

    @Column(name = "ctr")
    private Double ctr; // 媒体广告位点击率

    @Column(name = "five_minutes_clicknum")
    private Long fiveMinutesClicknum; // 5分钟内媒体广告位点击量

    @Column(name = "five_minutes_exposurenum")
    private Long fiveMinutesExposurenum; // 5分钟内媒体广告位曝光量

    @Column(name = "five_minutes_ctr")
    private Double fiveMinutesCtr;  // 5分钟内ctr

    @Column(name = "tow_hours_clicknum_last")
    private Long towHoursClicknumLast;  // 2小时内媒体广告位点击量(最近一个两小时数据)

    @Column(name = "tow_hours_exposurenum_last")
    private Long towHoursExposurenumLast;   // 2小时内媒体广告位曝光量(最近一个两小时数据)

    @Column(name = "tow_hours_clicknum")
    private Long towHoursClicknum;  // 2小时内媒体广告位点击量

    @Column(name = "tow_hours_exposurenum")
    private Long towHoursExposurenum;   // 2小时内媒体广告位曝光量

    @Column(name = "tow_hours_ctr")
    private Double towHoursCtr; // 2小时内ctr

    @Column(name = "twenty_four_hours_clicknum_last")
    private Long twentyFourHoursClicknumLast;   // 24小时内媒体广告位点击量(最近一个24小时数据)

    @Column(name = "twenty_four_hours_clicknum")
    private Long twentyFourHoursClicknum;   // 24小时内媒体广告位点击量

    @Column(name = "twenty_four_hours_exposurenum")
    private Long twentyFourHoursExposurenum;    // 24小时内媒体广告位曝光量

    @Column(name = "twenty_four_hours_exposurenum_last")
    private Long twentyFourHoursExposurenumLast; // 24小时内媒体广告位曝光量(最近一个24小时数据)

    @Column(name = "twenty_four_hours_ctr")
    private Double twentyFourHoursCtr;  // 24小时内ctr

    @Column(name = "total_clicknum")
    private Long totalClicknum; // 媒体广告位总点击量

    @Column(name = "total_exposurenum")
    private Long totalExposurenum;  // 媒体广告位总曝光量

    @Column(name = "status")
    private Integer status; // 广告位&素材状态 0 停用 1 启用 2删除

    @Column(name = "img_url")
    private String imgUrl;  // 素材图片

    @Column(name = "deleted")
    private Date deleted;   // 删除日期

    @Column(name = "updated")
    private Date updated;   // 修改时间
}