/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.facade;

import com.bxm.adapi.facade.model.MaterialDto;
import com.bxm.adapi.facade.model.MaterialEditDto;
import com.bxm.adapi.facade.model.MaterialRo;
import com.bxm.adapi.facade.model.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @ClassName MaterialService.java
 * @Description 功能描述： 素材库相关接口
 * @author leon 2018年4月2日 下午6:56:37
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "adapi")
public interface MaterialService {

    /**
     * @Description 方法描述： 新增
     * @author leon 2017年10月23日 下午4:17:41
     * @CopyRight 杭州微财网络科技有限公司
     * @param MaterialEditDto
     * @return
     * @throws Exception
     * @throws 
     */
    @RequestMapping(value = "/material/add", method = RequestMethod.POST)
    public ResultModel<Boolean> add(@RequestBody MaterialEditDto MaterialEditDto) throws  Exception;

    /**
     * @Description 方法描述： 批量逻辑删除
     * @author leon 2017年10月23日 下午4:17:47
     * @CopyRight 杭州微财网络科技有限公司
     * @param ids
     * @return
     * @throws Exception
     * @throws 
     */
    @RequestMapping(value = "/material/delete", method = RequestMethod.DELETE)
    public ResultModel<Boolean> delete(@RequestParam(value = "ids", required = true) List<Long> ids) throws 
                                                                                                     Exception;

    /**
     * @Description 方法描述： 修改
     * @author leon 2017年10月23日 下午4:17:54
     * @CopyRight 杭州微财网络科技有限公司
     * @param MaterialEditDto
     * @return
     * @throws Exception
     * @throws 
     */
    @RequestMapping(value = "/material/update", method = RequestMethod.PUT)
    public ResultModel<Boolean> update(@RequestBody MaterialEditDto MaterialEditDto) throws 
                                                                                     Exception;

    /**
     * @Description 方法描述： 根据条件查询列表
     * @author leon 2017年10月23日 下午4:18:02
     * @CopyRight 杭州微财网络科技有限公司
     * @param MaterialDto
     * @return
     */
    @RequestMapping(value = "/material/getList", method = RequestMethod.POST, produces = "application/json")
    public ResultModel<PageInfo<MaterialRo>> getList(@RequestBody MaterialDto MaterialDto);

    /**
     * @Description 方法描述： 批量新增
     * @author leon 2017年10月23日 下午4:17:41
     * @CopyRight 杭州微财网络科技有限公司
     * @param materialDto
     * @return
     * @throws Exception
     * @throws 
     */
    @RequestMapping(value = "/material/addBatch", method = RequestMethod.POST)
    public ResultModel<Boolean> addBatch(@RequestBody MaterialEditDto materialDto);



}
