/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.facade;

import com.bxm.adapi.facade.model.MediaAdPositionDto;
import com.bxm.adapi.facade.model.MediaAdPositionEditDto;
import com.bxm.adapi.facade.model.MediaAdPositionRo;
import com.bxm.adapi.facade.model.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author leon 2018年4月2日 上午11:58:51
 * @ClassName MediaAdPositionService.java
 * @Description 功能描述： 媒体广告位相关接口
 * @CopyRight 杭州微财网络科技有限公司
 */
@FeignClient(name = "adapi")
public interface MediaAdPositionService {

    /**
     * @param MediaAdPositionEditDto
     * @return
     * @throws Exception
     * @Description 方法描述： 新增
     * @author leon 2017年10月23日 下午4:17:41
     * @CopyRight 杭州微财网络科技有限公司
     */
    @RequestMapping(value = "/mediaAdPosition/add", method = RequestMethod.POST)
    public ResultModel<Boolean> add(@RequestBody MediaAdPositionEditDto MediaAdPositionEditDto) throws Exception;

    /**
     * @param ids
     * @return
     * @throws Exception
     * @Description 方法描述： 批量逻辑删除
     * @author leon 2017年10月23日 下午4:17:47
     * @CopyRight 杭州微财网络科技有限公司
     */
    @RequestMapping(value = "/mediaAdPosition/delete", method = RequestMethod.DELETE)
    public ResultModel<Boolean> delete(@RequestParam(value = "ids", required = true) List<Long> ids) throws Exception;

    /**
     * @param MediaAdPositionEditDto
     * @return
     * @throws Exception
     * @Description 方法描述： 修改
     * @author leon 2017年10月23日 下午4:17:54
     * @CopyRight 杭州微财网络科技有限公司
     */
    @RequestMapping(value = "/mediaAdPosition/update", method = RequestMethod.PUT)
    public ResultModel<Boolean> update(@RequestBody MediaAdPositionEditDto MediaAdPositionEditDto) throws Exception;


    @RequestMapping(value = "/mediaAdPosition/updateByAdPositionId", method = RequestMethod.PUT)
    ResultModel<Boolean> updateByAdPositionId(@RequestBody MediaAdPositionEditDto mediaAdPositionEditDto) throws Exception;

    /**
     * @param MediaAdPositionDto
     * @return
     * @Description 方法描述： 根据条件查询列表
     * @author leon 2017年10月23日 下午4:18:02
     * @CopyRight 杭州微财网络科技有限公司
     */
    @RequestMapping(value = "/mediaAdPosition/getList", method = RequestMethod.POST)
    public ResultModel<PageInfo<MediaAdPositionRo>> getList(@RequestBody MediaAdPositionDto MediaAdPositionDto);


    @RequestMapping("/mediaAdPosition/updateMaterialType")
    ResultModel<Boolean> updateMaterialType(@RequestParam("id") Long id, @RequestParam("materialType") String materialType);

    /**
     * 根据广告位id查询尺寸
     *
     * @param adPositionIds 广告位id
     * @return 广告位id为key, 尺寸为value
     */
    @RequestMapping("/mediaAdPosition/querySize")
    ResultModel<Map<String, String>> querySize(@RequestBody List<String> adPositionIds);

    /**
     * Description: 根据广告位ID 批量修改 素材类型
     * JDK version used:<JDK1.8>
     * Create Date：2019/1/30 16:35
     *
     * @param positionId   广告位ID
     * @param materialType 素材类型
     * @return com.bxm.adapi.facade.model.ResultModel<java.lang.Boolean>
     * @author hxpeng
     */
    @RequestMapping(value = "/mediaAdPosition/batchUpdateMaterialType", method = RequestMethod.POST)
    ResultModel<Boolean> batchUpdateMaterialType(@RequestParam(name = "positionId") String positionId,
                                                 @RequestParam(name = "materialType") String materialType);

}