package com.bxm.adapi.facade.model;

import io.swagger.annotations.ApiModelProperty;

/**
 * @ClassName AdPositionMaterialDto.java
 * @Description 功能描述：广告位素材查询对象
 * @author leon 2018年3月23日 下午2:45:46
 * @CopyRight 杭州微财网络科技有限公司
 */
public class AdPositionMaterialDto {

    /**
     * 页码
     */
    @ApiModelProperty(value = "页码，默认1")
    private Integer pageNum  = 1;
    /**
     * 每页数量
     */
    @ApiModelProperty(value = "每页数量，默认10，最大50")
    private Integer pageSize = 10;

    /**
     * 查询关键字
     */
    @ApiModelProperty(value = "查询关键字用来模糊匹配")
    private String  keywords;

    /**
     * 素材id
     */
    @ApiModelProperty(value = "素材id")
    private Long    id;
    /**
     * 媒体&广告位id
     */
    @ApiModelProperty(value = "媒体&广告位id")
    private Long    mediaAdPositionId;

    /**
     * 广告位&素材状态 0 停用 1 启用 2删除
     */
    @ApiModelProperty(value = "广告位&素材状态 0 停用 1 启用 2删除")
    private Integer status;

    private String    ctrCalcTime;  // ctr统计时间
    private String order; // 排序方式
    private String orderBy; // 根据什么排序

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    /**
     * @return the pageNum
     */
    public Integer getPageNum() {
        return pageNum;
    }

    /**
     * @param pageNum the pageNum to set
     */
    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * @return the pageSize
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * @param pageSize the pageSize to set
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * @return the keywords
     */
    public String getKeywords() {
        return keywords;
    }

    /**
     * @param keywords the keywords to set
     */
    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    /**
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the mediaAdPositionId
     */
    public Long getMediaAdPositionId() {
        return mediaAdPositionId;
    }

    /**
     * @param mediaAdPositionId the mediaAdPositionId to set
     */
    public void setMediaAdPositionId(Long mediaAdPositionId) {
        this.mediaAdPositionId = mediaAdPositionId;
    }

    /**
     * @return the status
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * @param status the status to set
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCtrCalcTime() {
        return ctrCalcTime;
    }

    public void setCtrCalcTime(String ctrCalcTime) {
        this.ctrCalcTime = ctrCalcTime;
    }
}
