/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.facade;

import com.bxm.adapi.facade.model.AdPositionMaterialDto;
import com.bxm.adapi.facade.model.AdPositionMaterialEditDto;
import com.bxm.adapi.facade.model.AdPositionMaterialRo;
import com.bxm.adapi.facade.model.ResultModel;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @ClassName AdPositionMaterialService.java
 * @Description 鍔熻兘鎻忚堪锛� 骞垮憡浣嶇礌鏉愮浉鍏虫帴鍙�
 * @author leon 2018骞�4鏈�2鏃� 涓婂崍11:59:59
 * @CopyRight 鏉窞寰储缃戠粶绉戞妧鏈夐檺鍏徃
 */
@FeignClient(name = "adapi")
public interface AdPositionMaterialService {

    /**
     * @Description 鏂规硶鎻忚堪锛� 鏂板
     * @author leon 2017骞�10鏈�23鏃� 涓嬪崍4:17:41
     * @CopyRight 鏉窞寰储缃戠粶绉戞妧鏈夐檺鍏徃
     * @param AdPositionMaterialEditDto
     * @return
     * @throws Exception
     * @throws 
     */
    @RequestMapping(value = "/adPositionMaterial/add", method = RequestMethod.POST)
    public ResultModel<Boolean> add(@RequestBody AdPositionMaterialEditDto AdPositionMaterialEditDto) throws 
                                                                                                      Exception;

    /**
     * 批量增加广告位素材接口
     * @param AdPositionMaterialEditDto
     * @return
     * @throws 
     * @throws Exception
     */
    @RequestMapping(value = "/adPositionMaterial/addBatch", method = RequestMethod.POST)
    public ResultModel<Boolean> addBatch(@RequestBody AdPositionMaterialEditDto AdPositionMaterialEditDto) throws 
            Exception;
    /**
     * @Description 鏂规硶鎻忚堪锛氫慨鏀圭姸鎬�
     * @author leon 2018骞�3鏈�29鏃� 涓嬪崍3:48:59
     * @CopyRight 鏉窞寰储缃戠粶绉戞妧鏈夐檺鍏徃
     * @param id
     * @param status
     * @return
     * @throws 
     * @throws Exception
     */
    @RequestMapping(value = "/adPositionMaterial/updateStatus", method = RequestMethod.PUT)
    public ResultModel<Boolean> updateStatus(@RequestParam(value = "id", required = true) Long id,
                                             @RequestParam(value = "status", required = true) Integer status) throws 
                                                                                                              Exception;

    /**
     * @Description 鏂规硶鎻忚堪锛� 淇敼
     * @author leon 2017骞�10鏈�23鏃� 涓嬪崍4:17:54
     * @CopyRight 鏉窞寰储缃戠粶绉戞妧鏈夐檺鍏徃
     * @param AdPositionMaterialEditDto
     * @return
     * @throws Exception
     * @throws 
     */
    @RequestMapping(value = "/adPositionMaterial/update", method = RequestMethod.PUT)
    public ResultModel<Boolean> update(@RequestBody AdPositionMaterialEditDto AdPositionMaterialEditDto) throws 
                                                                                                         Exception;

    /**
     * @Description 鏂规硶鎻忚堪锛� 鏍规嵁鏉′欢鏌ヨ鍒楄〃
     * @author leon 2017骞�10鏈�23鏃� 涓嬪崍4:18:02
     * @CopyRight 鏉窞寰储缃戠粶绉戞妧鏈夐檺鍏徃
     * @param AdPositionMaterialDto
     * @return
     */
    @RequestMapping(value = "/adPositionMaterial/getList", method = RequestMethod.POST)
    public ResultModel<PageInfo<AdPositionMaterialRo>> getList(@RequestBody AdPositionMaterialDto AdPositionMaterialDto);

    @RequestMapping(value = "/adPositionMaterial/updateCtr", method = RequestMethod.POST)
    ResultModel<Boolean> updateCtr(@RequestParam("id") Long id, @RequestParam(value = "clicknum", required = false) Long clicknum,
                                   @RequestParam(value = "exposurenum", required = false) Long exposurenum, @RequestParam("date") String date);
}
