package com.bxm.adapi.facade.model;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * @ClassName AdPositionMaterialEditDto.java
 * @Description 功能描述： 广告位素材编辑对象
 * @author leon 2018年3月23日 下午2:45:25
 * @CopyRight 杭州微财网络科技有限公司
 */
public class AdPositionMaterialEditDto {

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long    id;
    /**
     * 素材id
     */
    @ApiModelProperty(value = "素材id")
    private Long    materialId;

    /**
     * 素材id列表
     */
    @ApiModelProperty(value = "素材id列表")
    private List<Long>    materialIds;

    /**
     * 媒体&广告位id
     */
    @ApiModelProperty(value = "媒体&广告位id")
    private Long    mediaAdPositionId;

    /**
     * 素材名称
     */
    @ApiModelProperty(value = "素材名称")
    private String  name;

    @Deprecated
    @ApiModelProperty(value = "已废弃,使用images")
    private String  size;

    @Deprecated
    @ApiModelProperty(value = "已废弃,使用images")
    private String  imgUrl;

    /**
     * 素材图片列表
     */
    @ApiModelProperty(value = "素材图片列表")
    private List<String> imgUrls;
    /**
     * 广告位&素材状态 0 停用 1 启用 2删除
     */
    @ApiModelProperty(value = "广告位&素材状态 0 停用 1 启用 2删除")
    private Integer status;

    // v.20180710-positionType新增字段
    @ApiModelProperty(value = "素材标题")
    private String  title;  // 素材标题

    @ApiModelProperty(value = "素材导语")
    private String  introduction;  // 素材导语

    @ApiModelProperty(value = "图片集合")
    private List<ImageDto> images;

    private String materialType; // 素材类型
    /*===================================getter setter=========================================*/

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    /**
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the materialId
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * @param materialId the materialId to set
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * @return the mediaAdPositionId
     */
    public Long getMediaAdPositionId() {
        return mediaAdPositionId;
    }

    /**
     * @param mediaAdPositionId the mediaAdPositionId to set
     */
    public void setMediaAdPositionId(Long mediaAdPositionId) {
        this.mediaAdPositionId = mediaAdPositionId;
    }

    /**
     * @return the status
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * @param status the status to set
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the size
     */
    public String getSize() {
        return size;
    }

    /**
     * @param size the size to set
     */
    public void setSize(String size) {
        this.size = size;
    }

    /**
     * @return the imgUrl
     */
    public String getImgUrl() {
        return imgUrl;
    }

    /**
     * @param imgUrl the imgUrl to set
     */
    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public List<ImageDto> getImages() {
        return images;
    }

    public void setImages(List<ImageDto> images) {
        this.images = images;
    }

    public List<String> getImgUrls() {
        return imgUrls;
    }

    public void setImgUrls(List<String> imgUrls) {
        this.imgUrls = imgUrls;
    }

    public List<Long> getMaterialIds() {
        return materialIds;
    }

    public void setMaterialIds(List<Long> materialIds) {
        this.materialIds = materialIds;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
