package com.bxm.adapi.facade.model;

import io.swagger.annotations.ApiModelProperty;

import java.text.NumberFormat;
import java.util.List;

/**
 * @ClassName AdPositionMaterialVo.java
 * @Description 功能描述：素材查询返回对象
 * @author leon 2018年3月23日 下午2:46:50
 * @CopyRight 杭州微财网络科技有限公司
 */
public class AdPositionMaterialRo {

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long    id;
    /**
     * 素材id
     */
    @ApiModelProperty(value = "素材id")
    private Long    materialId;

    /**
     * 媒体&广告位id
     */
    @ApiModelProperty(value = "媒体&广告位id")
    private Long    mediaAdPositionId;

    /**
     * 素材名称
     */
    @ApiModelProperty(value = "素材名称")
    private String  name;

    /**
     * 素材图片
     */
    @Deprecated
    @ApiModelProperty(value = "素材图片,已废弃")
    private String  imgUrl;

    /**
     * 图片尺寸
     */
    @Deprecated
    @ApiModelProperty(value = "图片尺寸,已废弃")
    private String  size;

    /**
     * 点击量
     */
    @ApiModelProperty(value = "点击量")
    private Long    clicknum;

    /**
     * 曝光量
     */
    @ApiModelProperty(value = "曝光量")
    private Long    exposurenum;

    /**
     * 点击率：曝光量/点击量，默认90%
     */
    @ApiModelProperty(value = "点击率：曝光量/点击量，默认90%")
    private Double  ctr = 0.9;

    /**
     * 点击率百分比
     */
    @ApiModelProperty(value = "点击率百分比")
    private String  ctrPercent;

    /**
     * 广告位&素材状态 0 停用 1 启用 2删除
     */
    @ApiModelProperty(value = "广告位&素材状态 0 停用 1 启用 2删除")
    private Integer status;

    // v.20180710-positionType新增字段
    @ApiModelProperty(value = "素材标题")
    private String  title;  // 素材标题

    @ApiModelProperty(value = "素材导语")
    private String  introduction;  // 素材导语

    @ApiModelProperty(value = "图片集合")
    private List<ImageDto> images;

    private Double exposurenumRise; // 曝光环比
    private Double clicknumRise;//     点击环比
    private Double ctrRise;//          点击率环比
    private Double  historyCtr; // 历史点击率
    private String createDate; // 创建时间
    private String materialType; //素材类型

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public Double getExposurenumRise() {
        return exposurenumRise;
    }

    public void setExposurenumRise(Double exposurenumRise) {
        this.exposurenumRise = exposurenumRise;
    }

    public Double getClicknumRise() {
        return clicknumRise;
    }

    public void setClicknumRise(Double clicknumRise) {
        this.clicknumRise = clicknumRise;
    }

    public Double getCtrRise() {
        return ctrRise;
    }

    public void setCtrRise(Double ctrRise) {
        this.ctrRise = ctrRise;
    }

    public Double getHistoryCtr() {
        return historyCtr;
    }

    public void setHistoryCtr(Double historyCtr) {
        this.historyCtr = historyCtr;
    }

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the materialId
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * @param materialId the materialId to set
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * 媒体&广告位id
     * 
     * @return media_ad_position_id 媒体&广告位id
     */
    public Long getMediaAdPositionId() {
        return mediaAdPositionId;
    }

    /**
     * 媒体&广告位id
     * 
     * @param mediaAdPositionId 媒体&广告位id
     */
    public void setMediaAdPositionId(Long mediaAdPositionId) {
        this.mediaAdPositionId = mediaAdPositionId;
    }

    /**
     * 素材名称
     * 
     * @return name 素材名称
     */
    public String getName() {
        return name;
    }

    /**
     * 素材名称
     * 
     * @param name 素材名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 素材图片
     * 
     * @return img_url 素材图片
     */
    public String getImgUrl() {
        return imgUrl;
    }

    /**
     * 素材图片
     * 
     * @param imgUrl 素材图片
     */
    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl == null ? null : imgUrl.trim();
    }

    /**
     * 图片尺寸
     * 
     * @return size 图片尺寸
     */
    public String getSize() {
        return size;
    }

    /**
     * 图片尺寸
     * 
     * @param size 图片尺寸
     */
    public void setSize(String size) {
        this.size = size == null ? null : size.trim();
    }

    /**
     * @return the clicknum
     */
    public Long getClicknum() {
        if (clicknum == null) {
            return 0l;
        }
        return clicknum;
    }

    /**
     * @param clicknum the clicknum to set
     */
    public void setClicknum(Long clicknum) {
        this.clicknum = clicknum;
    }

    /**
     * @return the exposurenum
     */
    public Long getExposurenum() {
        if (exposurenum == null) {
            return 0l;
        }
        return exposurenum;
    }

    /**
     * @param exposurenum the exposurenum to set
     */
    public void setExposurenum(Long exposurenum) {
        this.exposurenum = exposurenum;
    }

    /**
     * @return the ctr
     */
    public Double getCtr() {
        return ctr;
    }

    /**
     * @param ctr the ctr to set
     */
    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    /**
     * @return the ctrPercent
     */
    public String getCtrPercent() {
        if (ctr != null) {
            NumberFormat nt = NumberFormat.getPercentInstance();
            // 设置百分数精确度2即保留两位小数
            nt.setMinimumFractionDigits(2);
            return nt.format(ctr);
        }
        return ctrPercent;
    }

    /**
     * @param ctrPercent the ctrPercent to set
     */
    public void setCtrPercent(String ctrPercent) {
        this.ctrPercent = ctrPercent;
    }

    /**
     * 状态 0 停用 1 启用
     * 
     * @return status 状态 0 停用 1 启用
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 状态 0 停用 1 启用
     * 
     * @param status 状态 0 停用 1 启用
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public List<ImageDto> getImages() {
        return images;
    }

    public void setImages(List<ImageDto> images) {
        this.images = images;
    }
}
