/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.facade.model;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * @ClassName MaterialAdPositionDto.java
 * @Description 功能描述：媒体&广告位查询对象
 * @author leon 2018年3月23日 下午2:52:10
 * @CopyRight 杭州微财网络科技有限公司
 */
public class MediaAdPositionDto {

    /**
     * 页码
     */
    @ApiModelProperty(value = "页码，默认1")
    private Integer pageNum  = 1;
    /**
     * 每页数量
     */
    @ApiModelProperty(value = "每页数量，默认10，最大50")
    private Integer pageSize = 10;

    private String order; // 排序方式
    private String orderBy; // 根据什么排序

    /**
     * 广告位id(appId+app_entrance_id)
     */
    @ApiModelProperty(value = "广告位id(appId+app_entrance_id)")
    private String  adPositionId;

    /**
     * app名称
     */
    @ApiModelProperty(value = "app名称")
    private String  appName;

    /**
     * 广告位名称
     */
    @ApiModelProperty(value = "广告位名称")
    private String  adPositionName;

    /**
     * 广告位图片素材尺寸
     */
    @ApiModelProperty(value = "广告位图片素材尺寸")
    private String  imageSize;

    /**
     * ctr统计时间开始时间
     */
    @ApiModelProperty(value = "查询收益开始时间yyyy-MM-dd格式")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String    ctrCalcStartTime;
    /**
     * ctr统计时间结束时间
     */
    @ApiModelProperty(value = "查询收益结束时间yyyy-MM-dd格式")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String    ctrCalcEndTime;

    private String materialType; // 素材类型

    private Integer dockingMethod; // 对接方式：0获取链接,1JS对接,2API对接

    public Integer getDockingMethod() {
        return dockingMethod;
    }

    public void setDockingMethod(Integer dockingMethod) {
        this.dockingMethod = dockingMethod;
    }

    public String getMaterialType() {
        return materialType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public String getOrder() {
        return order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    /**
     * @return the pageNum
     */
    public Integer getPageNum() {
        return pageNum;
    }

    /**
     * @param pageNum the pageNum to set
     */
    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * @return the pageSize
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * @param pageSize the pageSize to set
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * @return the adPositionId
     */
    public String getAdPositionId() {
        return adPositionId;
    }

    /**
     * @param adPositionId the adPositionId to set
     */
    public void setAdPositionId(String adPositionId) {
        this.adPositionId = adPositionId;
    }

    /**
     * @return the appName
     */
    public String getAppName() {
        return appName;
    }

    /**
     * @param appName the appName to set
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * @return the adPositionName
     */
    public String getAdPositionName() {
        return adPositionName;
    }

    /**
     * @param adPositionName the adPositionName to set
     */
    public void setAdPositionName(String adPositionName) {
        this.adPositionName = adPositionName;
    }

    /**
     * @return the imageSize
     */
    public String getImageSize() {
        return imageSize;
    }

    /**
     * @param imageSize the imageSize to set
     */
    public void setImageSize(String imageSize) {
        this.imageSize = imageSize;
    }

    public String getCtrCalcStartTime() {
        return ctrCalcStartTime;
    }

    public void setCtrCalcStartTime(String ctrCalcStartTime) {
        this.ctrCalcStartTime = ctrCalcStartTime;
    }

    public String getCtrCalcEndTime() {
        return ctrCalcEndTime;
    }

    public void setCtrCalcEndTime(String ctrCalcEndTime) {
        this.ctrCalcEndTime = ctrCalcEndTime;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
