/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.integration.xunfei;

import okhttp3.*;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.TimeUnit;

/**
 * @ClassName OkHttpUtils.java
 * @Description 功能描述： 用于发送http请求
 * @author leon 2017年10月27日 下午5:11:25
 * @CopyRight 杭州微财网络科技有限公司
 */
public class OkHttpUtils {

    // 创建一个 OkHttpClient
    private static final OkHttpClient mOkHttpClient = new OkHttpClient.Builder().connectTimeout(5,
                                                                                                TimeUnit.SECONDS).readTimeout(10,
                                                                                                                              TimeUnit.SECONDS).build();

    // 参数格式
    public static final MediaType     JSON          = MediaType.parse("application/json; charset=utf-8");

    /**
     * 方法描述:httpGet
     * 
     * @author leon 2017年5月10日 下午3:59:07
     * @param url serverHost可以带参数如http://www.baidu.com?param1=xxx&param2=xxx
     * @return
     * @throws IOException
     */
    public static String get(String url) throws IOException {
        Request request = new Request.Builder().url(url).get().build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    /**
     * 方法描述:httpGet
     * 
     * @author leon 2017年5月10日 下午3:59:07
     * @param url serverHost可以带参数如http://www.baidu.com?param1=xxx&param2=xxx
     * @param headers
     * @return
     * @throws IOException
     */
    public static String get(String url, Map<String, String> headers) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).get();
        // 添加http header
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    /**
     * @Description 方法描述： httpGet
     * @author leon 2017年10月27日 下午5:10:19
     * @CopyRight 杭州微财网络科技有限公司
     * @param url
     * @param params
     * @param headers
     * @return
     * @throws IOException
     */
    public static String get(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        // 构建请求参数
        StringBuffer paramSb = new StringBuffer();
        if (params != null) {
            for (Entry<String, Object> e : params.entrySet()) {

                if (e.getValue() != null) {
                    paramSb.append(URLEncoder.encode(e.getKey(), "UTF-8"));
                    paramSb.append("=");
                    // 将参数值urlEncode编码,防止传递中乱码
                    paramSb.append(URLEncoder.encode(e.getValue().toString(), "UTF-8"));
                    paramSb.append("&");
                }
            }
        }
        if (paramSb.length() > 0) {
            String paramStr = paramSb.toString();
            paramStr = paramStr.substring(0, paramStr.length() - 1);
            url += "?" + paramStr;
        }

        Request.Builder builder = new Request.Builder().url(url).get();
        // 添加http header
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();

        return response.body().string();
    }

    public static String post(String url, String params) throws IOException {
        RequestBody body = RequestBody.create(JSON, params);
        Request request = (new Request.Builder()).url(url).post(body).build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    /**
     * @Description 方法描述： httpPost
     * @author leon 2017年10月27日 下午5:10:13
     * @CopyRight 杭州微财网络科技有限公司
     * @param url
     * @param params
     * @param headers
     * @return
     * @throws IOException
     */
    public static String post(String url, String params, Map<String, String> headers) throws IOException {
        RequestBody body = RequestBody.create(JSON, params);
        Request.Builder builder = new Request.Builder().url(url).post(body);
        // 添加http header
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    /**
     * @Description 方法描述： httpPost
     * @author leon 2017年10月27日 下午5:10:09
     * @CopyRight 杭州微财网络科技有限公司
     * @param url
     * @param params
     * @param headers
     * @return
     * @throws IOException
     */
    public static String post(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {

        FormBody.Builder build = new FormBody.Builder();
        for (String key : params.keySet()) {
            if (params.get(key) != null) {
                build.add(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(params.get(key).toString(), "UTF-8"));
            }
        }
        RequestBody body = build.build();
        Request.Builder builder = new Request.Builder().url(url).post(body);
        // 添加http header
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }

        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();

        return response.body().string();
    }

    /**
     * @Description 方法描述： httpPut
     * @author leon 2017年10月27日 下午5:10:03
     * @CopyRight 杭州微财网络科技有限公司
     * @param url
     * @param params
     * @param headers
     * @return
     * @throws IOException
     */
    public static String put(String url, String params, Map<String, String> headers) throws IOException {
        RequestBody body = RequestBody.create(JSON, params);
        Request.Builder builder = new Request.Builder().url(url).put(body);
        // 添加http header
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();

    }

    /**
     * @Description 方法描述： httpPut
     * @author leon 2017年10月27日 下午5:09:54
     * @CopyRight 杭州微财网络科技有限公司
     * @param url
     * @param params
     * @param headers
     * @return
     * @throws IOException
     */
    public static String put(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        FormBody.Builder build = new FormBody.Builder();
        for (String key : params.keySet()) {
            if (params.get(key) != null) {
                build.add(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(params.get(key).toString(), "UTF-8"));
            }
        }
        RequestBody body = build.build();
        Request.Builder builder = new Request.Builder().url(url).put(body);
        // 添加http header
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }

        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    /**
     * @Description 方法描述： httpDelete
     * @author leon 2017年10月27日 下午5:09:48
     * @CopyRight 杭州微财网络科技有限公司
     * @param url
     * @param headers
     * @return
     * @throws IOException
     */
    public static String delete(String url, Map<String, String> headers) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).delete();
        // 添加http header
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    /**
     * @Description 方法描述： httpPatch
     * @author leon 2017年10月27日 下午5:09:25
     * @CopyRight 杭州微财网络科技有限公司
     * @param url
     * @param params
     * @param headers
     * @return
     * @throws IOException
     */
    public static String patch(String url, Map<String, Object> params, Map<String, String> headers) throws IOException {
        FormBody.Builder build = new FormBody.Builder();
        for (String key : params.keySet()) {
            if (params.get(key) != null) {
                build.add(URLEncoder.encode(key, "UTF-8"), URLEncoder.encode(params.get(key).toString(), "UTF-8"));
            }
        }

        RequestBody body = build.build();
        Request.Builder builder = new Request.Builder().url(url).put(body);
        // 添加http header
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }

        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();

    }

    /**
     * @Description 方法描述： httpPatch
     * @author leon 2017年10月27日 下午5:09:16
     * @CopyRight 杭州微财网络科技有限公司
     * @param url
     * @param params
     * @param headers
     * @return
     * @throws IOException
     */
    public static String patch(String url, String params, Map<String, String> headers) throws IOException {
        RequestBody body = RequestBody.create(JSON, params);
        Request.Builder builder = new Request.Builder().url(url).patch(body);
        // 添加http header
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

    /**
     * @Description 方法描述： httpHead
     * @author leon 2017年10月27日 下午5:08:48
     * @CopyRight 杭州微财网络科技有限公司
     * @param url
     * @param headers
     * @return
     * @throws IOException
     */
    public static String head(String url, Map<String, String> headers) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).head();
        // 添加http header
        if (headers != null && headers.size() > 0) {
            for (String headerKey : headers.keySet()) {
                builder.addHeader(headerKey, headers.get(headerKey));
            }
        }
        Request request = builder.build();
        Response response = mOkHttpClient.newCall(request).execute();
        return response.body().string();
    }

}
