/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.integration.xunfei;

import com.alibaba.fastjson.JSON;
import com.bxm.adapi.model.constant.Constant;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName UpdateXunfeiCreative.java
 * @Description 功能描述：科大讯飞更新素材
 * @author leon 2018年4月20日 上午9:45:22
 * @CopyRight 杭州微财网络科技有限公司
 */
@Service
public class UpdateXunfeiCreative {

    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateXunfeiCreative.class);

    @Resource
    private DingtalkMsgService dingtalkMsgService;

    /**
     * @Description 方法描述：获取accessToken
     * @author leon 2018年4月27日 上午9:59:45
     * @CopyRight 杭州微财网络科技有限公司
     * @param appId 讯飞分配的appId
     * @param appKey 讯飞分配的appKey
     * @param domain 讯飞分配的域名
     * @return
     * @throws IOException
     */
    private String getAccessToken(String appId, String appKey, String domain) throws IOException {
        Map<String, Object> params = new HashMap<>();
        params.put("appId", appId);
        params.put("appKey", appKey);
        String resultStr = OkHttpUtils.post(domain + XunfeiConstant.GET_TOKEN_URL, params, null);
        if (StringUtils.isNotBlank(resultStr)) {
            GetTokenResultVo getTokenResultVo = JSON.parseObject(resultStr, GetTokenResultVo.class);
            if (getTokenResultVo.getStatus() == XunfeiConstant.API_SUCCESS_STATUS) {
                return getTokenResultVo.getData().getAccessToken();
            }
        }
        return null;
    }

    /**
     * @Description 方法描述：更新素材
     * @author leon 2018年4月27日 上午9:59:38
     * @CopyRight 杭州微财网络科技有限公司
     * @param appId 讯飞分配的appId
     * @param appKey 讯飞分配的appKey
     * @param domain 讯飞分配的域名
     * @param imgUrl 替换的素材图片url
     * @param adPositionId 广告位id
     * @param adPositionMaterialId 广告位素材id
     * @param mediaAdPositionId 媒体广告位id
     */
    public void update(String appId, String appKey, String domain, String imgUrl, String adPositionId,
                       long adPositionMaterialId, long mediaAdPositionId) {
        String resultStr = "";
        try {
            CreativeDto creativeDto = new CreativeDto();
            List<Creative> creatives = new ArrayList<>();
            Creative creative = new Creative();
            creative.setContent(imgUrl);
            creative.setInputType(InputTypeEnum.PICTURE.getCode());
            creatives.add(creative);
            creativeDto.setAdPositionId(adPositionId);
            creativeDto.setAdPositionMaterialId(adPositionMaterialId);
            creativeDto.setMediaAdPositionId(mediaAdPositionId);

            String[] adPositionIdStrs = adPositionId.split("-");
            creativeDto.setBxmUrl(Constant.AD_HOST + "?appKey=" + adPositionIdStrs[0] + "&appType=app&appEntrance="
                                  + adPositionIdStrs[1] + "&business=money");
            creativeDto.setCreative(creatives);

            Map<String, String> headers = new HashMap<>();
            headers.put("Access-Token", getAccessToken(appId, appKey, domain));
            resultStr = OkHttpUtils.post(domain + XunfeiConstant.UPDATE_CREATIVE_URL, JSON.toJSONString(creativeDto),
                                         headers);
            if (StringUtils.isNotBlank(resultStr)) {
                XunfeiResultVo xunfeiResultVo = JSON.parseObject(resultStr, XunfeiResultVo.class);
                if (xunfeiResultVo.getStatus() != XunfeiConstant.API_SUCCESS_STATUS) {
                    // 该落地页无效，请联系运营
                    StringBuilder msg = new StringBuilder("替换讯飞广告位素材出错：" + xunfeiResultVo.getMsg());
                    if (StringUtils.equals(xunfeiResultVo.getMsg(), "该落地页无效，请联系运营")) {
                        msg.append("，此广告位讯飞未配置或已下线，请先关闭该广告位相关素材或者联系讯飞运营尽快配置，广告位id：").append(adPositionId)
                                .append(",素材id：").append(adPositionMaterialId);
                    } else if (StringUtils.equals(xunfeiResultVo.getMsg(), "素材格式不符合")) {
                        msg.append("，此广告位素材尺寸不符合讯飞要求，请尽快联系相关运营并修改，广告位id：").append(adPositionId)
                                .append(",素材id：").append(adPositionMaterialId);
                    } else {
                        msg.append("，广告位id：").append(adPositionId)
                                .append(",素材id：").append(adPositionMaterialId);
                    }
                    dingtalkMsgService.sendMsg(msg.toString(), false);
                }
            }
        } catch (Exception e) {
            // 钉钉通知
            String msg = "替换讯飞广告位素材出错,调用讯飞接口:" + domain + XunfeiConstant.UPDATE_CREATIVE_URL + "，出现错误异常";
            dingtalkMsgService.sendErrorMsg(msg, false, e);
            LOGGER.error("替换讯飞广告位素材出错,resultStr={}:", resultStr, e);
        }

    }
}
