/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.integration.xunfei;

import com.alibaba.fastjson.JSONObject;
import com.bxm.adapi.integration.xunfei.OkHttpUtils;
import com.bxm.adapi.model.constant.Constant;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DingtalkMsgService {
    private static final Logger log = LoggerFactory.getLogger(DingtalkMsgService.class);
    @Value(value="${spring.profiles.active}")
    private String env;

    public void sendMsg(String content, Boolean isAtAll) {
        try {
            String url = this.isProd() ? "https://oapi.dingtalk.com/robot/send?access_token=1d1cb013250f30c9fc99fa4421e47603c1bde5743dabd2b713b5b1b2a3f9714e" : "https://oapi.dingtalk.com/robot/send?access_token=286c319d5372a26356c61106c129286a5535269896273bc0857d57d576c7ba62";
            content = this.prefix() + content;
            JSONObject jsonParam = new JSONObject();
            HashMap<String, String> text = new HashMap<String, String>();
            text.put("content", content);
            HashMap<String, Object> at = new HashMap<String, Object>();
            if (this.isProd()) {
                at.put("atMobiles", Constant.DINGTALK_WEBHOOK_AT_OPERATE_USER_LIST);
                at.put("isAtAll", isAtAll);
            }
            jsonParam.put("msgtype", (Object)"text");
            jsonParam.put("text", text);
            jsonParam.put("at", at);
            OkHttpUtils.post(url, jsonParam.toJSONString());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public void sendErrorMsg(String contentTitle, Boolean isAtAll, Exception exception) {
        try {
            String url = this.isProd() ? "https://oapi.dingtalk.com/robot/send?access_token=1d1cb013250f30c9fc99fa4421e47603c1bde5743dabd2b713b5b1b2a3f9714e" : "https://oapi.dingtalk.com/robot/send?access_token=286c319d5372a26356c61106c129286a5535269896273bc0857d57d576c7ba62";
            JSONObject jsonParam = new JSONObject();
            StringBuilder content = new StringBuilder(this.prefix() + contentTitle + "\n");
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter((Writer)sw, true));
            content.append(sw.toString());
            HashMap<String, String> text = new HashMap<String, String>();
            text.put("content", content.toString());
            HashMap<String, Object> at = new HashMap<String, Object>();
            if (this.isProd()) {
                at.put("atMobiles", Constant.DINGTALK_WEBHOOK_AT_TEC_USER_LIST);
                at.put("isAtAll", isAtAll);
            }
            jsonParam.put("msgtype", (Object)"text");
            jsonParam.put("text", text);
            jsonParam.put("at", at);
            OkHttpUtils.post(url, jsonParam.toJSONString());
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    private String prefix() {
        if ("dev".equals(this.env)) {
            return "[\u5f00\u53d1\u73af\u5883]";
        }
        if ("test".equals(this.env)) {
            return "[\u6d4b\u8bd5\u73af\u5883]";
        }
        return "[\u751f\u4ea7\u73af\u5883]";
    }

    private boolean isProd() {
        return !"dev".equals(this.env) && !"test".equals(this.env);
    }
}

