package com.bxm.adapi.model;

import com.bxm.adapi.model.exception.AdApiCodeType;
import com.bxm.util.dto.BaseException;
import com.bxm.util.dto.ResultModel;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @author yirenjie
 * createDate:  2018/7/12
 */
public class EnhanceResultModel<T> extends ResultModel<T> {

    public EnhanceResultModel() {
        setSuccessed(true);
    }

    public EnhanceResultModel(AdApiCodeType codeType) {
        setSuccessed(false);
        setErrorCode(codeType.getErrorCode());
        setErrorDesc(codeType.getErrorMsg());
    }

    public EnhanceResultModel(BaseException e) {
        setSuccessed(false);
        setErrorCode(e.getErrorCode());
        setErrorDesc(e.getMessage());
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
