package com.bxm.adapi.model.bo;

import com.bxm.adapi.model.BaseModel;
import com.bxm.adapi.model.constant.Constant;
import com.bxm.adapi.model.dto.ImageDto;
import io.swagger.annotations.ApiModelProperty;

import java.text.NumberFormat;
import java.util.List;

/**
 * @Description 功能描述：素材查询返回对象
 * @author yirenjie
 * @CopyRight 杭州微财网络科技有限公司
 */
public class AdPositionMaterialBo extends BaseModel {

    /**
     * id
     */
    private Long    id;

    /**
     * 素材id
     */
    private Long    materialId;

    /**
     * 媒体&广告位id
     */
    private Long    mediaAdPositionId;

    /**
     * 素材名称
     */
    private String  name;

    /**
     * 素材图片
     */
    private String  imgUrl;

    /**
     * 图片尺寸
     */
    private String  size;


    /**
     * 广告位&素材状态 0 停用 1 启用 2删除
     */
    private Integer status;

    // v.20180710-positionType新增字段
    private String  title;  // 素材标题

    private String  introduction;  // 素材导语

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the materialId
     */
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * @param materialId the materialId to set
     */
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    /**
     * 媒体&广告位id
     * 
     * @return media_ad_position_id 媒体&广告位id
     */
    public Long getMediaAdPositionId() {
        return mediaAdPositionId;
    }

    /**
     * 媒体&广告位id
     * 
     * @param mediaAdPositionId 媒体&广告位id
     */
    public void setMediaAdPositionId(Long mediaAdPositionId) {
        this.mediaAdPositionId = mediaAdPositionId;
    }

    /**
     * 素材名称
     * 
     * @return name 素材名称
     */
    public String getName() {
        return name;
    }

    /**
     * 素材名称
     * 
     * @param name 素材名称
     */
    public void setName(String name) {
        this.name = name == null ? null : name.trim();
    }

    /**
     * 素材图片
     * 
     * @return img_url 素材图片
     */
    public String getImgUrl() {
        return imgUrl;
    }

    /**
     * 素材图片
     * 
     * @param imgUrl 素材图片
     */
    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl == null ? null : imgUrl.trim();
    }

    /**
     * 图片尺寸
     * 
     * @return size 图片尺寸
     */
    public String getSize() {
        return size;
    }

    /**
     * 图片尺寸
     * 
     * @param size 图片尺寸
     */
    public void setSize(String size) {
        this.size = size == null ? null : size.trim();
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }
}
