/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.model.constant;

import java.util.Arrays;
import java.util.List;

/**
 * @ClassName Constant.java
 * @Description 功能描述：
 * @author leon 2018年3月22日 上午10:26:51
 * @CopyRight 杭州微财网络科技有限公司
 */
public class Constant {

    /**
     * 系统默认页码
     */
    public static final int          DEFAULT_PAGE_NUM                        = 1;

    /**
     * 系统默认每页数量
     */
    public static final int          DEFAULT_PAGE_SIZE                       = 10;

    /**
     * 系统默认每页最大数量
     */
    public static final int          DEFAULT_MAX_PAGE_SIZE                   = 50;

    /**
     * 系统默认排序字段
     */
    public static final String       DEFAULT_ORDER_PARAM                     = "updated";

    /**
     * 系统默认排序方式
     */
    public static final String       DEFAULT_ORDER_TYPE                      = "desc";

    /** 广告host **/
    public final static String       AD_HOST                                 = "http://m.cudaojia.com";

    /** 广告api host **/
    public final static String       ADAPI_HOST_TEST                         = "http://test.api.bianxianmao.com/adapi/adMaterialApi/redirectAdUrl";

    /** 广告api host **/
    public final static String       ADAPI_HOST_PROD                         = "https://api.bianxianmao.com/adapi/adMaterialApi/redirectAdUrl";

    /** 素材默认最大点击数 */
    public final static int          MATERIAL_DEFAULT_MAX_CLICKNUM           = 100;

    /** 广告位素材默认CTR */
    public final static double       AD_POSITION_MATERIAL_DEFAULT_CTR        = 0.9;

    /** 广告位素材CTR计算时间间隔 :分钟 */
    public final static int          AD_POSITION_MATERIAL_CTR_CALAC_INTERVAL = 5;

    /** 5分钟 */
    public final static int          FIVE_MINUTES                            = 5;

    /** 2小时：120分钟 */
    public final static int          TOW_HOURS                               = 60 * 2;
    /** 2小时的循环周期 */
    public final static int          TOW_HOURS_CALC_CYCLE                    = Constant.TOW_HOURS
                                                                               / Constant.FIVE_MINUTES;

    /** 24小时：1440分钟 */
    public final static int          TWENTY_FOUR_HOURS                       = 60 * 24;
    /** 24小时的循环周期 */
    public final static int          TWENTY_FOUR_HOURS_CALC_CYCLE            = Constant.TWENTY_FOUR_HOURS
                                                                               / Constant.FIVE_MINUTES;
    /** 钉钉机器人webhook url (技术) **/
    public final static String       DINGTALK_WEBHOOK_TEC                    = "https://oapi.dingtalk.com/robot/send?access_token=e1e9506d6b070295723ad46099162f2c1d4ea5ac74e78790b41587367ed3e474";
    /** 钉钉机器人webhook url (运营) **/
    public final static String       DINGTALK_WEBHOOK_OPERATE                = "https://oapi.dingtalk.com/robot/send?access_token=1d1cb013250f30c9fc99fa4421e47603c1bde5743dabd2b713b5b1b2a3f9714e";

    /** 钉钉机器人@技术人员对象 **/
    public final static List<String> DINGTALK_WEBHOOK_AT_TEC_USER_LIST       = Arrays.asList("13335387510");                                                                                        // 杨冬
    /** 钉钉机器人@运营人员对象 **/
    public final static List<String> DINGTALK_WEBHOOK_AT_OPERATE_USER_LIST   = Arrays.asList("18367126365",                                                                                         // 张彬
                                                                                             "18042317645",                                                                                         // 朱圣慧
                                                                                             "15858242186",                                                                                         // 时亚娜
                                                                                             "18514008912");                                                                                        // 李颖

    /** 讯飞appKey **/
    public final static String       XUN_FEI_APP_KEY                         = "35135b347df24726a9802fa74db301be";
}
