package com.bxm.adapi.model.dto;

import java.util.Date;

import com.bxm.adapi.model.BaseModel;
import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.adapi.model.CustomJsonDateDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import io.swagger.annotations.ApiModelProperty;

/**
 * @ClassName AdPositionMaterialDto.java
 * @Description 功能描述：广告位素材查询对象
 * @author leon 2018年3月23日 下午2:45:46
 * @CopyRight 杭州微财网络科技有限公司
 */
public class AdPositionMaterialDto extends BaseModel {

    /**
     * 页码
     */
    @ApiModelProperty(value = "页码，默认1")
    private Integer pageNum  = 1;
    /**
     * 每页数量
     */
    @ApiModelProperty(value = "每页数量，默认10，最大50")
    private Integer pageSize = 10;

    /**
     * 查询关键字
     */
    @ApiModelProperty(value = "查询关键字用来模糊匹配")
    private String  keywords;

    /**
     * 素材id
     */
    @ApiModelProperty(value = "素材id")
    private Long    id;
    /**
     * 媒体&广告位id
     */
    @ApiModelProperty(value = "媒体&广告位id")
    private Long    mediaAdPositionId;

    /**
     * 广告位&素材状态 0 停用 1 启用 2删除
     */
    @ApiModelProperty(value = "广告位&素材状态 0 停用 1 启用 2删除")
    private Integer status;

    /**
     * ctr统计时间开始时间
     */
    @ApiModelProperty(value = "查询收益开始时间yyyy-MM-dd格式")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date    ctrCalcStartTime;
    /**
     * ctr统计时间结束时间
     */
    @ApiModelProperty(value = "查询收益结束时间yyyy-MM-dd格式")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date    ctrCalcEndTime;

    /**
     * @return the pageNum
     */
    public Integer getPageNum() {
        return pageNum;
    }

    /**
     * @param pageNum the pageNum to set
     */
    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * @return the pageSize
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * @param pageSize the pageSize to set
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * @return the keywords
     */
    public String getKeywords() {
        return keywords;
    }

    /**
     * @param keywords the keywords to set
     */
    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    /**
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the mediaAdPositionId
     */
    public Long getMediaAdPositionId() {
        return mediaAdPositionId;
    }

    /**
     * @param mediaAdPositionId the mediaAdPositionId to set
     */
    public void setMediaAdPositionId(Long mediaAdPositionId) {
        this.mediaAdPositionId = mediaAdPositionId;
    }

    /**
     * @return the status
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * @param status the status to set
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * @return the ctrCalcStartTime
     */
    public Date getCtrCalcStartTime() {
        return ctrCalcStartTime;
    }

    /**
     * @param ctrCalcStartTime the ctrCalcStartTime to set
     */
    @JsonDeserialize(using = CustomJsonDateDeserializer.class)
    public void setCtrCalcStartTime(Date ctrCalcStartTime) {
        this.ctrCalcStartTime = ctrCalcStartTime;
    }

    /**
     * @return the ctrCalcEndTime
     */
    public Date getCtrCalcEndTime() {
        return ctrCalcEndTime;
    }

    /**
     * @param ctrCalcEndTime the ctrCalcEndTime to set
     */
    @JsonDeserialize(using = CustomJsonDateDeserializer.class)
    public void setCtrCalcEndTime(Date ctrCalcEndTime) {
        this.ctrCalcEndTime = ctrCalcEndTime;
    }

}
