/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.model.dto;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.bxm.adapi.model.CustomJsonDateDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import io.swagger.annotations.ApiModelProperty;

/**
 * @ClassName MaterialAdPositionDto.java
 * @Description 功能描述：媒体&广告位查询对象
 * @author leon 2018年3月23日 下午2:52:10
 * @CopyRight 杭州微财网络科技有限公司
 */
public class MediaAdPositionDto {

    /**
     * 页码
     */
    @ApiModelProperty(value = "页码，默认1")
    private Integer pageNum  = 1;
    /**
     * 每页数量
     */
    @ApiModelProperty(value = "每页数量，默认10，最大50")
    private Integer pageSize = 10;

    /**
     * 广告位id(appId+app_entrance_id)
     */
    @ApiModelProperty(value = "广告位id(appId+app_entrance_id)")
    private String  adPositionId;

    /**
     * app名称
     */
    @ApiModelProperty(value = "app名称")
    private String  appName;

    /**
     * 广告位名称
     */
    @ApiModelProperty(value = "广告位名称")
    private String  adPositionName;

    /**
     * 广告位图片素材尺寸
     */
    @ApiModelProperty(value = "广告位图片素材尺寸")
    private String  imageSize;

    /**
     * ctr统计时间开始时间
     */
    @ApiModelProperty(value = "查询收益开始时间yyyy-MM-dd格式")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date    ctrCalcStartTime;
    /**
     * ctr统计时间结束时间
     */
    @ApiModelProperty(value = "查询收益结束时间yyyy-MM-dd格式")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date    ctrCalcEndTime;

    /**
     * @return the pageNum
     */
    public Integer getPageNum() {
        return pageNum;
    }

    /**
     * @param pageNum the pageNum to set
     */
    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    /**
     * @return the pageSize
     */
    public Integer getPageSize() {
        return pageSize;
    }

    /**
     * @param pageSize the pageSize to set
     */
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    /**
     * @return the adPositionId
     */
    public String getAdPositionId() {
        return adPositionId;
    }

    /**
     * @param adPositionId the adPositionId to set
     */
    public void setAdPositionId(String adPositionId) {
        this.adPositionId = adPositionId;
    }

    /**
     * @return the appName
     */
    public String getAppName() {
        return appName;
    }

    /**
     * @param appName the appName to set
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * @return the adPositionName
     */
    public String getAdPositionName() {
        return adPositionName;
    }

    /**
     * @param adPositionName the adPositionName to set
     */
    public void setAdPositionName(String adPositionName) {
        this.adPositionName = adPositionName;
    }

    /**
     * @return the imageSize
     */
    public String getImageSize() {
        return imageSize;
    }

    /**
     * @param imageSize the imageSize to set
     */
    public void setImageSize(String imageSize) {
        this.imageSize = imageSize;
    }

    /**
     * @return the ctrCalcStartTime
     */
    public Date getCtrCalcStartTime() {
        return ctrCalcStartTime;
    }

    /**
     * @param ctrCalcStartTime the ctrCalcStartTime to set
     */
    @JsonDeserialize(using = CustomJsonDateDeserializer.class)
    public void setCtrCalcStartTime(Date ctrCalcStartTime) {
        this.ctrCalcStartTime = ctrCalcStartTime;
    }

    /**
     * @return the ctrCalcEndTime
     */
    public Date getCtrCalcEndTime() {
        return ctrCalcEndTime;
    }

    /**
     * @param ctrCalcEndTime the ctrCalcEndTime to set
     */
    @JsonDeserialize(using = CustomJsonDateDeserializer.class)
    public void setCtrCalcEndTime(Date ctrCalcEndTime) {
        this.ctrCalcEndTime = ctrCalcEndTime;
    }

}
