package com.bxm.adapi.model.dto;

import com.bxm.adapi.model.BaseModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @ClassName AdPositionMaterialEditDto.java
 * @Description 功能描述： 广告位素材编辑对象
 * @author leon 2018年3月23日 下午2:45:25
 * @CopyRight 杭州微财网络科技有限公司
 */
public class MediaAdPositionEditDto extends BaseModel {

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long   id;

    /**
     * 广告位id(appId+app_entrance_id)
     */
    @ApiModelProperty(value = "广告位id(appId+app_entrance_id)")
    private String adPositionId;

    /**
     * app名称
     */
    @ApiModelProperty(value = "app名称")
    private String appName;

    /**
     * 广告位名称
     */
    @ApiModelProperty(value = "广告位名称")
    private String adPositionName;

    /**
     * 广告位图片素材尺寸
     */
    @ApiModelProperty(value = "广告位图片素材尺寸")
    private String imageSize;

    /**
     * 媒体类型
     */
    @ApiModelProperty(value = "媒体类型")
    private String mediaType;

    /**
     * 媒体分类
     */
    @ApiModelProperty(value = "媒体分类")
    private String mediaClass;
    /**
     * 媒体子分类
     */
    @ApiModelProperty(value = "媒体子分类")
    private String mediaChildClass;

    @ApiModelProperty(value = "广告位类型")
    private String positionType;

    /**
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the adPositionId
     */
    public String getAdPositionId() {
        return adPositionId;
    }

    /**
     * @param adPositionId the adPositionId to set
     */
    public void setAdPositionId(String adPositionId) {
        this.adPositionId = adPositionId;
    }

    /**
     * @return the appName
     */
    public String getAppName() {
        return appName;
    }

    /**
     * @param appName the appName to set
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * @return the adPositionName
     */
    public String getAdPositionName() {
        return adPositionName;
    }

    /**
     * @param adPositionName the adPositionName to set
     */
    public void setAdPositionName(String adPositionName) {
        this.adPositionName = adPositionName;
    }

    /**
     * @return the imageSize
     */
    public String getImageSize() {
        return imageSize;
    }

    /**
     * @param imageSize the imageSize to set
     */
    public void setImageSize(String imageSize) {
        this.imageSize = imageSize;
    }

    /**
     * @return the mediaType
     */
    public String getMediaType() {
        return mediaType;
    }

    /**
     * @param mediaType the mediaType to set
     */
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    /**
     * @return the mediaClass
     */
    public String getMediaClass() {
        return mediaClass;
    }

    /**
     * @param mediaClass the mediaClass to set
     */
    public void setMediaClass(String mediaClass) {
        this.mediaClass = mediaClass;
    }

    /**
     * @return the mediaChildClass
     */
    public String getMediaChildClass() {
        return mediaChildClass;
    }

    /**
     * @param mediaChildClass the mediaChildClass to set
     */
    public void setMediaChildClass(String mediaChildClass) {
        this.mediaChildClass = mediaChildClass;
    }

    public String getPositionType() {
        return positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }
}
