package com.bxm.adapi.model.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName AdPositionMateriaStatus.java
 * @Description 功能描述： 广告位&素材状态: 0 停用 1 启用 2删除
 * @author leon 2018年3月27日 上午11:43:55
 * @CopyRight 杭州微财网络科技有限公司
 */
public enum AdPositionMateriaStatus {
                                     /**
                                      * 停用
                                      */
                                     Disable(0, "停用"),
                                     /**
                                      * 启用
                                      */
                                     Enable(1, "启用"),
                                     /**
                                      * 删除
                                      */
                                     DELETE(2, "删除");

    private int    code;

    private String name;

    /**
     * @param code
     * @param name
     */
    private AdPositionMateriaStatus(int code, String name){
        this.code = code;
        this.name = name;
    }

    /**
     * @return the code
     */
    public int getCode() {
        return code;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * 所有状态
     * 
     * @return
     */
    public static Map<Integer, String> getAllState() {
        AdPositionMateriaStatus[] sts = AdPositionMateriaStatus.values();
        Map<Integer, String> maps = new HashMap<Integer, String>();
        for (AdPositionMateriaStatus tmp : sts) {
            maps.put(tmp.code, tmp.name);
        }
        return maps;
    }

    /**
     * 根据code得到name
     * 
     * @param code
     * @return
     */
    public static String getName(int code) {
        for (AdPositionMateriaStatus state : AdPositionMateriaStatus.values()) {
            if (state.getCode() == code) {
                return state.getName();
            }
        }
        return "状态异常";
    }

}
