package com.bxm.adapi.model.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 类ActivityType.java的实现描述:活动类型枚举
 * 
 * @author leon 2016年8月16日 下午3:23:49
 */
public enum OpeationType {
                          /**
                           * 点击量
                           */
                          CLICK_COUNT(1, "点击量"),
                          /**
                           * 曝光量
                           */
                          BAOGUAGN_COUNT(2, "曝光量");

    private int    code;

    private String name;

    /**
     * @param code
     * @param name
     */
    private OpeationType(int code, String name){
        this.code = code;
        this.name = name;
    }

    /**
     * @return the code
     */
    public int getCode() {
        return code;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * 所有状态
     * 
     * @return
     */
    public static Map<Integer, String> getAllState() {
        OpeationType[] sts = OpeationType.values();
        Map<Integer, String> maps = new HashMap<Integer, String>();
        for (OpeationType tmp : sts) {
            maps.put(tmp.code, tmp.name);
        }
        return maps;
    }

    /**
     * 根据code得到name
     * 
     * @param code
     * @return
     */
    public static String getName(int code) {
        for (OpeationType state : OpeationType.values()) {
            if (state.getCode() == code) {
                return state.getName();
            }
        }
        return "状态异常";
    }

}
