/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.model.ro;

import java.text.NumberFormat;

import com.aliyuncs.http.PositionType;
import com.bxm.adapi.model.BaseModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @ClassName MaterialAdPositionRo.java
 * @Description 功能描述：素材广告位查询返回对象
 * @author leon 2018年3月23日 下午2:52:00
 * @CopyRight 杭州微财网络科技有限公司
 */
public class MediaAdPositionRo extends BaseModel {

    /**
     * id
     */
    @ApiModelProperty(value = "id")
    private Long    id;

    /**
     * 广告位id(appId+app_entrance_id)
     */
    @ApiModelProperty(value = "广告位id(appId+app_entrance_id)")
    private String  adPositionId;

    /**
     * app名称
     */
    @ApiModelProperty(value = "app名称")
    private String  appName;

    /**
     * 广告位名称
     */
    @ApiModelProperty(value = "广告位名称")
    private String  adPositionName;

    /**
     * 广告位图片素材尺寸
     */
    @ApiModelProperty(value = "广告位图片素材尺寸")
    private String  imageSize;

    /**
     * 媒体类型
     */
    @ApiModelProperty(value = "媒体类型")
    private String  mediaType;

    /**
     * 媒体分类
     */
    @ApiModelProperty(value = "媒体分类")
    private String  mediaClass;
    /**
     * 媒体子分类
     */
    @ApiModelProperty(value = "媒体子分类")
    private String  mediaChildClass;

    /**
     * 媒体素材数量
     */
    @ApiModelProperty(value = "媒体素材数量")
    private Integer materialNum;

    /**
     * 媒体广告位点击量
     */
    @ApiModelProperty(value = "媒体广告位点击量")
    private Long    clicknum;

    /**
     * 媒体广告位点曝光量
     */
    @ApiModelProperty(value = "媒体广告位点曝光量")
    private Long    exposurenum;

    /**
     * 媒体广告位点点击率：曝光量/点击量
     */
    @ApiModelProperty(value = "广告位点点击率：曝光量/点击量")
    private Double  ctr;

    /**
     * 点击率百分比
     */
    @ApiModelProperty(value = "点击率百分比")
    private String  ctrPercent;

    @ApiModelProperty(value = "广告位类型")
    private String positionType;

    /**
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * @return the adPositionId
     */
    public String getAdPositionId() {
        return adPositionId;
    }

    /**
     * @param adPositionId the adPositionId to set
     */
    public void setAdPositionId(String adPositionId) {
        this.adPositionId = adPositionId;
    }

    /**
     * @return the appName
     */
    public String getAppName() {
        return appName;
    }

    /**
     * @param appName the appName to set
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * @return the adPositionName
     */
    public String getAdPositionName() {
        return adPositionName;
    }

    /**
     * @param adPositionName the adPositionName to set
     */
    public void setAdPositionName(String adPositionName) {
        this.adPositionName = adPositionName;
    }

    /**
     * @return the imageSize
     */
    public String getImageSize() {
        return imageSize;
    }

    /**
     * @param imageSize the imageSize to set
     */
    public void setImageSize(String imageSize) {
        this.imageSize = imageSize;
    }

    /**
     * @return the mediaType
     */
    public String getMediaType() {
        return mediaType;
    }

    /**
     * @param mediaType the mediaType to set
     */
    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    /**
     * @return the mediaClass
     */
    public String getMediaClass() {
        return mediaClass;
    }

    /**
     * @param mediaClass the mediaClass to set
     */
    public void setMediaClass(String mediaClass) {
        this.mediaClass = mediaClass;
    }

    /**
     * @return the mediaChildClass
     */
    public String getMediaChildClass() {
        return mediaChildClass;
    }

    /**
     * @param mediaChildClass the mediaChildClass to set
     */
    public void setMediaChildClass(String mediaChildClass) {
        this.mediaChildClass = mediaChildClass;
    }

    /**
     * @return the materialNum
     */
    public Integer getMaterialNum() {
        return materialNum;
    }

    /**
     * @param materialNum the materialNum to set
     */
    public void setMaterialNum(Integer materialNum) {
        this.materialNum = materialNum;
    }

    /**
     * @return the clicknum
     */
    public Long getClicknum() {
        if (clicknum == null) {
            return 0l;
        }
        return clicknum;
    }

    /**
     * @param clicknum the clicknum to set
     */
    public void setClicknum(Long clicknum) {
        this.clicknum = clicknum;
    }

    /**
     * @return the exposurenum
     */
    public Long getExposurenum() {
        if (exposurenum == null) {
            return 0l;
        }
        return exposurenum;
    }

    /**
     * @param exposurenum the exposurenum to set
     */
    public void setExposurenum(Long exposurenum) {
        this.exposurenum = exposurenum;
    }

    /**
     * @return the ctr
     */
    public Double getCtr() {
        if (ctr == null) {
            return 0d;
        }
        return ctr;
    }

    /**
     * @param ctr the ctr to set
     */
    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    /**
     * @return the ctrPercent
     */
    public String getCtrPercent() {
        if (ctr != null) {
            NumberFormat nt = NumberFormat.getPercentInstance();
            // 设置百分数精确度2即保留两位小数
            nt.setMinimumFractionDigits(2);
            return nt.format(ctr);
        }
        return ctrPercent;
    }

    /**
     * @param ctrPercent the ctrPercent to set
     */
    public void setCtrPercent(String ctrPercent) {
        this.ctrPercent = ctrPercent;
    }

    public String getPositionType() {
        return positionType;
    }

    public void setPositionType(String positionType) {
        this.positionType = positionType;
    }
}
