/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.model.vo;

import java.io.Serializable;
import java.util.List;

import com.bxm.adapi.model.BaseModel;
import com.bxm.adapi.model.dto.ImageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @ClassName AdMaterialApiVo.java
 * @Description 功能描述： 广告素材api返回对象
 * @author leon 2018年3月26日 下午4:04:02
 * @CopyRight 杭州微财网络科技有限公司
 */
@ApiModel(description = "广告素材api返回对象")
public class AdMaterialApiVo extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "广告位素材id")
    private Long              adPositionMaterialId; // 广告位素材id

    @ApiModelProperty(value = "媒体&广告位id")
    private Long              mediaAdPositionId;    // 媒体&广告位id

    @ApiModelProperty(value = "广告素材图片url")
    private String            imgUrl;               // 图片url

    @ApiModelProperty(value = "广告跳转链接")
    private String            redirectUrl;          // 广告跳转链接

    // v.20180710-positionType新增字段
    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "导语")
    private String introduction;

    @ApiModelProperty(value = "图片集合")
    private List<ImageDto> images;


    /**
     * @return the adPositionMaterialId
     */
    public Long getAdPositionMaterialId() {
        return adPositionMaterialId;
    }

    /**
     * @param adPositionMaterialId the adPositionMaterialId to set
     */
    public void setAdPositionMaterialId(Long adPositionMaterialId) {
        this.adPositionMaterialId = adPositionMaterialId;
    }

    /**
     * @return the mediaAdPositionId
     */
    public Long getMediaAdPositionId() {
        return mediaAdPositionId;
    }

    /**
     * @param mediaAdPositionId the mediaAdPositionId to set
     */
    public void setMediaAdPositionId(Long mediaAdPositionId) {
        this.mediaAdPositionId = mediaAdPositionId;
    }

    /**
     * @return the imgUrl
     */
    public String getImgUrl() {
        return imgUrl;
    }

    /**
     * @param imgUrl the imgUrl to set
     */
    public void setImgUrl(String imgUrl) {
        String[] imgUrls = imgUrl.split("\\|");
        this.imgUrl = imgUrls[0];
    }

    /**
     * @return the redirectUrl
     */
    public String getRedirectUrl() {
        return redirectUrl;
    }

    /**
     * @param redirectUrl the redirectUrl to set
     */
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getIntroduction() {
        return introduction;
    }

    public void setIntroduction(String introduction) {
        this.introduction = introduction;
    }

    public List<ImageDto> getImages() {
        return images;
    }

    public void setImages(List<ImageDto> images) {
        this.images = images;
    }
}
