/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.adapi.model.vo;

import java.io.Serializable;

import com.bxm.adapi.model.constant.Constant;

import io.swagger.annotations.ApiModel;

/**
 * @ClassName AdMaterialCtrVo.java
 * @Description 功能描述：
 * @author leon 2018年3月27日 上午10:04:10
 * @CopyRight 杭州微财网络科技有限公司
 */
@ApiModel(description = "广告素材ctr对象")
public class AdMaterialCtrVo implements Serializable {

    private static final long serialVersionUID                 = 1L;

    /**
     * 媒体广告位总点击量
     */
    private long              totalClicknum                    = 0;

    /**
     * 媒体广告位总曝光量
     */
    private long              totalExposurenum                 = 0;
    /**
     * 媒体广告位点击率
     */
    private double            ctr                              = Constant.AD_POSITION_MATERIAL_DEFAULT_CTR;

    /**
     * 5分钟内媒体广告位点击量
     */
    private long              fiveMinutesClicknum              = 0;

    /**
     * 5分钟内媒体广告位曝光量
     */
    private long              fiveMinutesExposurenum           = 0;

    /**
     * 5分钟内ctr
     */
    private double            fiveMinutesCtr                   = 0;

    /**
     * 2小时内媒体广告位点击量
     */
    private long              towHoursClicknum                 = 0;

    /**
     * 2小时内媒体广告位曝光量
     */
    private long              towHoursExposurenum              = 0;

    /**
     * 2小时内媒体广告位点击量(最近一个两小时数据)
     */
    private long              towHoursClicknumOfLast           = 0;

    /**
     * 2小时内媒体广告位曝光量(最近一个两小时数据)
     */
    private long              towHoursExposurenumOfLast        = 0;
    /**
     * 2小时内ctr
     */
    private double            towHoursCtr                      = 0;

    /**
     * 24小时内媒体广告位点击量
     */
    private long              twentyFourHoursClicknum          = 0;

    /**
     * 24小时内媒体广告位曝光量
     */
    private long              twentyFourHoursExposurenum       = 0;

    /**
     * 24小时内媒体广告位点击量(最近一个24小时数据)
     */
    private long              twentyFourHoursClicknumOfLast    = 0;

    /**
     * 24小时内媒体广告位曝光量(最近一个24小时数据)
     */
    private long              twentyFourHoursExposurenumOfLast = 0;

    /**
     * 24小时内ctr
     */
    private double            twentyFourHoursCtr               = 0;

    /**
     * 广告位&素材状态 0 停用 1 启用 2删除
     */
    private Integer           status;
    /**
     * ctr计算周期
     */
    private long              calcCycle                        = 0;

    /**
     * 广告位素材id
     */
    private Long              adPositionMaterialId;

    /**
     * 媒体&广告位id
     */
    private Long              mediaAdPositionId;

    /**
     * 图片url
     */
    private String            imgUrl;

    /**
     * @return the totalClicknum
     */
    public long getTotalClicknum() {
        return totalClicknum;
    }

    /**
     * @param totalClicknum the totalClicknum to set
     */
    public void setTotalClicknum(long totalClicknum) {
        this.totalClicknum = totalClicknum;
    }

    /**
     * @return the totalExposurenum
     */
    public long getTotalExposurenum() {
        return totalExposurenum;
    }

    /**
     * @param totalExposurenum the totalExposurenum to set
     */
    public void setTotalExposurenum(long totalExposurenum) {
        this.totalExposurenum = totalExposurenum;
    }

    /**
     * @return the ctr
     */
    public double getCtr() {
        return ctr;
    }

    /**
     * @param ctr the ctr to set
     */
    public void setCtr(double ctr) {
        this.ctr = ctr;
    }

    /**
     * @return the fiveMinutesClicknum
     */
    public long getFiveMinutesClicknum() {
        return fiveMinutesClicknum;
    }

    /**
     * @param fiveMinutesClicknum the fiveMinutesClicknum to set
     */
    public void setFiveMinutesClicknum(long fiveMinutesClicknum) {
        this.fiveMinutesClicknum = fiveMinutesClicknum;
    }

    /**
     * @return the fiveMinutesExposurenum
     */
    public long getFiveMinutesExposurenum() {
        return fiveMinutesExposurenum;
    }

    /**
     * @param fiveMinutesExposurenum the fiveMinutesExposurenum to set
     */
    public void setFiveMinutesExposurenum(long fiveMinutesExposurenum) {
        this.fiveMinutesExposurenum = fiveMinutesExposurenum;
    }

    /**
     * @return the fiveMinutesCtr
     */
    public double getFiveMinutesCtr() {
        return fiveMinutesCtr;
    }

    /**
     * @param fiveMinutesCtr the fiveMinutesCtr to set
     */
    public void setFiveMinutesCtr(double fiveMinutesCtr) {
        this.fiveMinutesCtr = fiveMinutesCtr;
    }

    /**
     * @return the towHoursClicknum
     */
    public long getTowHoursClicknum() {
        return towHoursClicknum;
    }

    /**
     * @param towHoursClicknum the towHoursClicknum to set
     */
    public void setTowHoursClicknum(long towHoursClicknum) {
        this.towHoursClicknum = towHoursClicknum;
    }

    /**
     * @return the towHoursExposurenum
     */
    public long getTowHoursExposurenum() {
        return towHoursExposurenum;
    }

    /**
     * @param towHoursExposurenum the towHoursExposurenum to set
     */
    public void setTowHoursExposurenum(long towHoursExposurenum) {
        this.towHoursExposurenum = towHoursExposurenum;
    }

    /**
     * @return the towHoursClicknumOfLast
     */
    public long getTowHoursClicknumOfLast() {
        return towHoursClicknumOfLast;
    }

    /**
     * @param towHoursClicknumOfLast the towHoursClicknumOfLast to set
     */
    public void setTowHoursClicknumOfLast(long towHoursClicknumOfLast) {
        this.towHoursClicknumOfLast = towHoursClicknumOfLast;
    }

    /**
     * @return the towHoursExposurenumOfLast
     */
    public long getTowHoursExposurenumOfLast() {
        return towHoursExposurenumOfLast;
    }

    /**
     * @param towHoursExposurenumOfLast the towHoursExposurenumOfLast to set
     */
    public void setTowHoursExposurenumOfLast(long towHoursExposurenumOfLast) {
        this.towHoursExposurenumOfLast = towHoursExposurenumOfLast;
    }

    /**
     * @return the towHoursCtr
     */
    public double getTowHoursCtr() {
        return towHoursCtr;
    }

    /**
     * @param towHoursCtr the towHoursCtr to set
     */
    public void setTowHoursCtr(double towHoursCtr) {
        this.towHoursCtr = towHoursCtr;
    }

    /**
     * @return the twentyFourHoursClicknum
     */
    public long getTwentyFourHoursClicknum() {
        return twentyFourHoursClicknum;
    }

    /**
     * @param twentyFourHoursClicknum the twentyFourHoursClicknum to set
     */
    public void setTwentyFourHoursClicknum(long twentyFourHoursClicknum) {
        this.twentyFourHoursClicknum = twentyFourHoursClicknum;
    }

    /**
     * @return the twentyFourHoursExposurenum
     */
    public long getTwentyFourHoursExposurenum() {
        return twentyFourHoursExposurenum;
    }

    /**
     * @param twentyFourHoursExposurenum the twentyFourHoursExposurenum to set
     */
    public void setTwentyFourHoursExposurenum(long twentyFourHoursExposurenum) {
        this.twentyFourHoursExposurenum = twentyFourHoursExposurenum;
    }

    /**
     * @return the twentyFourHoursClicknumOfLast
     */
    public long getTwentyFourHoursClicknumOfLast() {
        return twentyFourHoursClicknumOfLast;
    }

    /**
     * @param twentyFourHoursClicknumOfLast the twentyFourHoursClicknumOfLast to set
     */
    public void setTwentyFourHoursClicknumOfLast(long twentyFourHoursClicknumOfLast) {
        this.twentyFourHoursClicknumOfLast = twentyFourHoursClicknumOfLast;
    }

    /**
     * @return the twentyFourHoursExposurenumOfLast
     */
    public long getTwentyFourHoursExposurenumOfLast() {
        return twentyFourHoursExposurenumOfLast;
    }

    /**
     * @param twentyFourHoursExposurenumOfLast the twentyFourHoursExposurenumOfLast to set
     */
    public void setTwentyFourHoursExposurenumOfLast(long twentyFourHoursExposurenumOfLast) {
        this.twentyFourHoursExposurenumOfLast = twentyFourHoursExposurenumOfLast;
    }

    /**
     * @return the twentyFourHoursCtr
     */
    public double getTwentyFourHoursCtr() {
        return twentyFourHoursCtr;
    }

    /**
     * @param twentyFourHoursCtr the twentyFourHoursCtr to set
     */
    public void setTwentyFourHoursCtr(double twentyFourHoursCtr) {
        this.twentyFourHoursCtr = twentyFourHoursCtr;
    }

    /**
     * @return the status
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * @param status the status to set
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * @return the calcCycle
     */
    public long getCalcCycle() {
        return calcCycle;
    }

    /**
     * @param calcCycle the calcCycle to set
     */
    public void setCalcCycle(long calcCycle) {
        this.calcCycle = calcCycle;
    }

    /**
     * @return the adPositionMaterialId
     */
    public Long getAdPositionMaterialId() {
        return adPositionMaterialId;
    }

    /**
     * @param adPositionMaterialId the adPositionMaterialId to set
     */
    public void setAdPositionMaterialId(Long adPositionMaterialId) {
        this.adPositionMaterialId = adPositionMaterialId;
    }

    /**
     * @return the mediaAdPositionId
     */
    public Long getMediaAdPositionId() {
        return mediaAdPositionId;
    }

    /**
     * @param mediaAdPositionId the mediaAdPositionId to set
     */
    public void setMediaAdPositionId(Long mediaAdPositionId) {
        this.mediaAdPositionId = mediaAdPositionId;
    }

    /**
     * @return the imgUrl
     */
    public String getImgUrl() {
        return imgUrl;
    }

    /**
     * @param imgUrl the imgUrl to set
     */
    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

}
