/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi;

import com.bxm.util.StringUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableAutoConfiguration
@Configuration
@RefreshScope
@EnableSwagger2
public class Swagger2 {
    @Value(value="${version}")
    private String version;
    @Value(value="${spring.profiles.active}")
    private String profilesActive;

    @Bean
    public Docket createRestApi() {
        if (StringUtil.equals((CharSequence)this.profilesActive, (CharSequence)"dev") || StringUtil.equals((CharSequence)this.profilesActive, (CharSequence)"test")) {
            return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"com.bxm.adapi")).paths(PathSelectors.any()).build();
        }
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfoOnline()).select().paths(PathSelectors.none()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("\u53d8\u73b0\u732b\u5e7f\u544a\u7d20\u6750api\u63a5\u53e3\u6587\u6863").description("\u4ec5\u4f9b\u6d4b\u8bd5\u8054\u8c03").termsOfServiceUrl("http://localhost:19301/swagger-ui.html").contact("leon").version(this.version).build();
    }

    private ApiInfo apiInfoOnline() {
        return new ApiInfoBuilder().title("").description("").termsOfServiceUrl("").contact("").version("").build();
    }
}

