/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.web.controller;

import com.bxm.adapi.model.vo.AdMaterialApiVo;
import com.bxm.adapi.service.AdMaterialApiService;
import com.bxm.adapi.service.InitMaterialApiCacheService;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@EnableAutoConfiguration
@RefreshScope
@RestController
@Api(description="\u5e7f\u544a\u7d20\u6750Api\u76f8\u5173\u63a5\u53e3")
@RequestMapping(value={"/adMaterialApi"})
@Deprecated
public class AdMaterialApiController {
    @Autowired
    private AdMaterialApiService adMaterialApiService;
    @Autowired
    private InitMaterialApiCacheService initMaterialApiCacheService;

    @RequestMapping(value={"/getAdMaterial"}, method={RequestMethod.GET})
    public ResultModel<AdMaterialApiVo> getAdMaterial(HttpServletRequest request) throws Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.adMaterialApiService.getAdMaterial(this.getAdMaterialParams(request)));
        return resultModel;
    }

    @RequestMapping(value={"/redirectAdUrl"}, method={RequestMethod.GET})
    public void redirectAdUrl(HttpServletResponse response, HttpServletRequest request) throws Exception {
        response.sendRedirect(this.adMaterialApiService.redirectAdUrl(this.getAdMaterialParams(request)));
    }

    private HashMap<String, String> getAdMaterialParams(HttpServletRequest request) throws ValidateException, Exception {
        String adPositionId = request.getParameter("adPositionId");
        if (StringUtil.isBlank((CharSequence)adPositionId)) {
            throw new ValidateException("\u5e7f\u544a\u4f4d\u4e0d\u5b58\u5728,\u8bf7\u5728\u540e\u53f0\u914d\u7f6e");
        }
        String[] adPositionIdStrs = adPositionId.split("-");
        if (adPositionIdStrs.length != 2) {
            throw new ValidateException("\u5e7f\u544a\u4f4d\u9519\u8bef,\u8bf7\u5728\u540e\u53f0\u914d\u7f6e");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paramName = ((String)enu.nextElement()).trim();
            if (!StringUtil.isNotBlank((CharSequence)request.getParameter(paramName))) continue;
            params.put(paramName, URLDecoder.decode(request.getParameter(paramName), "UTF-8"));
        }
        return params;
    }

    @ApiOperation(value="\u521d\u59cb\u5316\u7f13\u5b58\u4fe1\u606f\uff0c\u7528\u4e8eredis db\u8fc1\u79fb", notes="\u4ec5\u4ec5\u7528\u4e8e\u6570\u636e\u5e93\u8fc1\u79fb\u6216\u8005\u6570\u636e\u4e22\u5931\u65f6")
    @RequestMapping(value={"/initCache"}, method={RequestMethod.GET})
    public void initCache() throws Exception {
        this.initMaterialApiCacheService.initCache();
    }

    @ApiOperation(value="\u8bb0\u5f55\u5a92\u4f53\u5e7f\u544a\u4f4d\u7d20\u6750\u66dd\u5149")
    @ApiImplicitParams(value={@ApiImplicitParam(name="adPositionId", value="\u5e7f\u544a\u4f4did", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="mediaAdPositionId", value="\u5a92\u4f53\u5e7f\u544a\u4f4did", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="adPositionMaterialId", value="\u5e7f\u544a\u4f4d\u7d20\u6750id", required=true, paramType="query", dataType="int")})
    @RequestMapping(value={"/exposure"}, method={RequestMethod.GET})
    public ResultModel<Boolean> exposure(@RequestParam(value="adPositionId", required=true) String adPositionId, @RequestParam(value="mediaAdPositionId", required=true) Long mediaAdPositionId, @RequestParam(value="adPositionMaterialId", required=true) Long adPositionMaterialId) throws Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.adMaterialApiService.exposure(adPositionId, mediaAdPositionId, adPositionMaterialId));
        return resultModel;
    }

    @ApiOperation(value="\u8bb0\u5f55\u5a92\u4f53\u5e7f\u544a\u4f4d\u7d20\u6750\u70b9\u51fb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="adPositionId", value="\u5e7f\u544a\u4f4did", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="mediaAdPositionId", value="\u5a92\u4f53\u5e7f\u544a\u4f4did", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="adPositionMaterialId", value="\u5e7f\u544a\u4f4d\u7d20\u6750id", required=true, paramType="query", dataType="int")})
    @RequestMapping(value={"/click"}, method={RequestMethod.GET})
    public ResultModel<Boolean> click(@RequestParam(value="adPositionId", required=true) String adPositionId, @RequestParam(value="mediaAdPositionId", required=true) Long mediaAdPositionId, @RequestParam(value="adPositionMaterialId", required=true) Long adPositionMaterialId) throws Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.adMaterialApiService.click(adPositionId, mediaAdPositionId, adPositionMaterialId));
        return resultModel;
    }
}

