/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.web.controller;

import com.bxm.adapi.config.RedisClient;
import com.bxm.adapi.model.constant.AdApiRedisKey;
import com.bxm.adapi.model.enums.OpeationType;
import com.bxm.util.DateUtil;
import com.bxm.util.dto.ResultModel;
import io.swagger.annotations.Api;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@EnableAutoConfiguration
@RefreshScope
@RestController
@Api(description="\u5e7f\u544a\u7d20\u6750\u6570\u636e\u7edf\u8ba1\u76f8\u5173\u63a5\u53e3")
public class InfoAdEntranceClickController {
    @Autowired
    private RedisClient redisClient;

    @RequestMapping(value={"/click"}, method={RequestMethod.GET})
    public ResultModel<Boolean> getList(@RequestParam(value="appKey", required=true) String appKey, @RequestParam(value="entranceId", required=true) String entranceId, @RequestParam(value="opeation", required=true) int opeation) throws Exception {
        ResultModel resultModel = new ResultModel();
        this.incr(appKey, entranceId, opeation);
        return resultModel;
    }

    @Async
    private void incr(String appKey, String entranceId, int opeation) throws Exception {
        if (opeation == OpeationType.CLICK_COUNT.getCode()) {
            this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.datetime + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.opeation + OpeationType.CLICK_COUNT.getCode() + AdApiRedisKey.appKey + appKey + AdApiRedisKey.entranceId + entranceId, null);
        } else if (opeation == OpeationType.BAOGUAGN_COUNT.getCode()) {
            this.redisClient.incr(AdApiRedisKey.redisKey + AdApiRedisKey.datetime + DateUtil.dateTo8String((Date)new Date()) + AdApiRedisKey.opeation + OpeationType.BAOGUAGN_COUNT.getCode() + AdApiRedisKey.appKey + appKey + AdApiRedisKey.entranceId + entranceId, null);
        }
    }
}

