/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.adapi.web.controller;

import com.bxm.adapi.model.EnhanceResultModel;
import com.bxm.adapi.model.dto.MediaAdPositionDto;
import com.bxm.adapi.model.dto.MediaAdPositionEditDto;
import com.bxm.adapi.model.exception.AdApiCodeType;
import com.bxm.adapi.model.ro.MediaAdPositionRo;
import com.bxm.adapi.service.MediaAdPositionService;
import com.bxm.util.dto.BaseException;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@EnableAutoConfiguration
@RefreshScope
@RestController
@RequestMapping(value={"/mediaAdPosition"})
@Api(description="\u5a92\u4f53\u5e7f\u544a\u4f4d\u76f8\u5173\u63a5\u53e3")
public class MediaAdPositionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaAdPositionController.class);
    @Autowired
    private MediaAdPositionService mediaAdPositionService;

    @ApiOperation(value="\u65b0\u589e", notes="\u6839\u636e\u4f20\u5165\u5bf9\u8c61\u65b0\u589e\u4fe1\u606f")
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public ResultModel<Boolean> add(@RequestBody MediaAdPositionEditDto mediaAdPositionEditDto) throws ValidateException, Exception {
        LOGGER.info("\u8bf7\u6c42\u65b0\u589e\u5e7f\u544a\u4f4d\u53c2\u6570:{}", (Object)mediaAdPositionEditDto);
        ResultModel resultModel = new ResultModel();
        try {
            resultModel.setReturnValue((Object)this.mediaAdPositionService.add(mediaAdPositionEditDto));
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42\u65b0\u589e\u5e7f\u544a\u4f4d\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("\u8bf7\u6c42\u65b0\u589e\u5e7f\u544a\u4f4d\u54cd\u5e94:{}", resultModel.getReturnValue());
        return resultModel;
    }

    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664", notes="\u6839\u636eurl\u4e2d\u7684id\u6765\u5220\u9664\u5bf9\u8c61")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id,\u591a\u4e2a\u4ee5\u9017\u53f7\u4f20\u9012", required=true, paramType="query", dataType="list")})
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public ResultModel<Boolean> delete(@RequestParam(value="ids", required=true) List<Long> ids) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.mediaAdPositionService.deletes(ids));
        return resultModel;
    }

    @ApiOperation(value="\u4fee\u6539", notes="\u6839\u636e\u4f20\u5165\u5bf9\u8c61\u4fee\u6539\u4fe1\u606f")
    @RequestMapping(value={"/update"}, method={RequestMethod.PUT})
    public ResultModel<Boolean> update(@RequestBody MediaAdPositionEditDto MediaAdPositionEditDto2) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.mediaAdPositionService.update(MediaAdPositionEditDto2));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636e\u5e7f\u544a\u4f4d\u4fee\u6539\u5a92\u4f53\u4fe1\u606f", notes="\u6839\u636e\u5e7f\u544a\u4f4d\u4fee\u6539\u5a92\u4f53\u4fe1\u606f")
    @RequestMapping(value={"/updateByAdPositionId"}, method={RequestMethod.PUT})
    public ResultModel<Boolean> updateByAdPositionId(@RequestBody MediaAdPositionEditDto MediaAdPositionEditDto2) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.mediaAdPositionService.updateByAdPositionId(MediaAdPositionEditDto2));
        return resultModel;
    }

    @RequestMapping(value={"/updateMaterialType"})
    public ResultModel<Boolean> updateMaterialType(Long id, String materialType) {
        EnhanceResultModel resultModel = new EnhanceResultModel();
        try {
            LOGGER.info("\u66f4\u65b0\u7d20\u6750\u7c7b\u578b\u8bf7\u6c42\u53c2\u6570:id={},materialType={}", (Object)id, (Object)materialType);
            resultModel.setReturnValue((Object)this.mediaAdPositionService.updateMaterialType(id, materialType));
        }
        catch (ValidateException e) {
            LOGGER.error("\u66f4\u65b0\u7d20\u6750\u7c7b\u578b\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            resultModel = new EnhanceResultModel((BaseException)e);
        }
        catch (Exception e) {
            LOGGER.error("\u66f4\u65b0\u7d20\u6750\u7c7b\u578b\u53d1\u751f\u672a\u77e5\u5f02\u5e38:", (Throwable)e);
            resultModel = new EnhanceResultModel(AdApiCodeType.SYSTEM_ERROR);
        }
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868", notes="\u5206\u9875\uff0c\u9ed8\u8ba410\u6761\u6bcf\u9875\u3002")
    @RequestMapping(value={"/getList"}, method={RequestMethod.POST})
    public ResultModel<PageInfo<MediaAdPositionRo>> getList(@RequestBody MediaAdPositionDto MediaAdPositionDto2) {
        ResultModel resultModel = new ResultModel();
        if (MediaAdPositionDto2 == null) {
            MediaAdPositionDto2 = new MediaAdPositionDto();
        }
        if (MediaAdPositionDto2.getPageSize() > 50) {
            MediaAdPositionDto2.setPageSize(Integer.valueOf(50));
        }
        resultModel.setReturnValue((Object)this.mediaAdPositionService.getList(MediaAdPositionDto2));
        return resultModel;
    }
}

