package com.bxm.report.web.base;
/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */


import com.bxm.acl.facade.AclAuthInterceptor;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.log.facade.dao.LogModel;
import com.bxm.report.service.utils.IPUtils;
import com.bxm.report.facade.logs.LogsIntegration;
import com.bxm.report.model.dao.user.User;

import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * <h3>基类</h3>
 * <p></p>
 *
 * @author hcmony
 * @since V1.0.0, 2017/12/25 16:13
 */


@RestController
public class BaseController {

	public static final String SESSION_USER_NAME = "user";
	private static final Logger logger = Logger.getLogger(BaseController.class);
	@Autowired
	private LogsIntegration logsIntegration;

	/**
	 * @description 获取用户信息
	 * @author hcmony
	 * @time 2017/12/29
	 * @CopyRight 杭州微财网络科技有限公司
	 * @param request
	 * @param response
	 * @return com.bxm.adsmanager.model.dao.user.User
	 */
	public User getUser(HttpServletRequest request, HttpServletResponse response){
		User user = new User();
		try {
			UserVo userVo =(UserVo) request.getAttribute(AclAuthInterceptor.USER_KEY);
			if (userVo != null) {
				BeanUtils.copyProperties(userVo, user);
			}
		}catch (Exception e){
			logger.error(e.getMessage(),e);
		}
		user.setIp(IPUtils.getIp(request));
		return  user;
	}

	/**
	 * @description 用户日志 记录
	 * @author hcmony
	 * @time 2018/4/25
	 * @param user
	 * @param content
	 * @param adticketId
	 * @return void
	 */
	public void addLogs(User user, String content, String adticketId){

		try {
			String userAccount = "-";
			if(user!=null){
				userAccount = user.getUserAllRole();
			}
			LogModel logModel = new LogModel.Builder()
					.userName(userAccount)
					.userAccount(user.getUsername())
					.parentAccount(userAccount)
					.content(content)
					.adticketId(adticketId)
					.ip(user.getIp())
					.build();
			logsIntegration.add(logModel);
		}catch (Exception e){
			logger.error(e.getMessage(),e);
		}
	}
}
