package com.bxm.report.web.common;

import com.bxm.app.model.vo.QueryPositionIdAndNameVo;
import com.bxm.report.model.vo.adposition.QueryMediaNameVo;
import com.bxm.report.model.vo.ticket.QueryTicketNameVo;
import com.bxm.report.service.adkeeper.AdPositionService;
import com.bxm.report.service.ticket.AdTicketService;
import com.bxm.report.web.base.BaseController;
import com.bxm.util.dto.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 文 件 名 :
 * CopyRright (c) 2008-xxxx:
 * 文件编号：
 * 创 建 人： hxpeng
 * 日 期： 2018/8/21 17:20
 * 修 改 人：
 * 日 期：
 * 描 述： 通用的一些请求接口
 * 版 本 号： v1
 */
@Slf4j
@RestController
@RequestMapping("/reportor/common")
public class CommonController extends BaseController {

    @Autowired
    private AdTicketService adTicketService;

    @Autowired
    private AdPositionService adPositionService;

    /**
     * Description: 查询广告券名称或ID 根据广告券ID或名称
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/21 18:25
     */
    @RequestMapping(value = "/findTicketAll", method = RequestMethod.GET)
    public ResultModel<List<QueryTicketNameVo>> findTicketByParam(@RequestParam(value = "keyWords") String keyWords) {
        ResultModel<List<QueryTicketNameVo>> rs = new ResultModel<>();
        rs.setReturnValue(adTicketService.queryTicketIdOrNameByKeywords(keyWords));
        return rs;
    }


    /**
     * Description: 查询媒体名称或ID 根据媒体ID或名称
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/21 18:25
     */
    @RequestMapping(value = "/findMediaAll", method = RequestMethod.GET)
    public ResultModel<List<QueryMediaNameVo>> findMediaAll(@RequestParam(value = "keyWords") String keyWords) {
        ResultModel<List<QueryMediaNameVo>> rs = new ResultModel<>();
        rs.setReturnValue(adPositionService.queryMediaIdOrNameByKeywords(keyWords));
        return rs;
    }

    /**
     * Description: 查询广告位名称或ID 根据广告位ID或名称
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/8/21 18:25
     */
    @RequestMapping(value = "/findPositionAll", method = RequestMethod.GET)
    public ResultModel<List<QueryPositionIdAndNameVo>> findMediaAll(@RequestParam(value = "keyWords", required = false) String keyWords,
                                                               @RequestParam(value = "appKey", required = false) String appKey) {
        ResultModel<List<QueryPositionIdAndNameVo>> rs = new ResultModel<>();
        rs.setReturnValue(adPositionService.queryPositionIdOrNameByKeywords(keyWords, appKey));
        return rs;
    }
}
