package com.bxm.report.web.common;

import com.bxm.report.model.common.CommonSearchDto;
import com.bxm.report.model.dto.media.InfoMediaMsgDto;
import com.bxm.report.model.dto.media.InfoPositionMsgDto;
import com.bxm.report.service.media.MediaPositionService;
import com.bxm.report.web.base.BaseController;
import com.bxm.util.dto.ResultModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Title: MediaPositionController
 * @Description: 获取媒体和广告位的信息
 * @author xavier
 * @date 2018年3月14日
 */
@RequestMapping("/mediaPosition")
@RestController
public class MediaPositionController extends BaseController {

    private static final Logger logger = Logger.getLogger(MediaPositionController.class);

    @Autowired
    private MediaPositionService mediaPositionService;

    /**
     * @Title: findAll
     * @Description:  通过APPKEY 和  关键字查询媒体信息列表
     * @author xavier
     * @date 2018年3月14日
     */
    @RequestMapping(value = "/findMediaAll", method = RequestMethod.GET)
    public ResultModel<List<InfoMediaMsgDto>> findMediaAll(CommonSearchDto search) {
        ResultModel<List<InfoMediaMsgDto>> rs = new ResultModel<List<InfoMediaMsgDto>>();
        try {
            rs.setReturnValue(mediaPositionService.findMediaAll(search));
        } catch (Exception e) {
            logger.error("媒体信息列表查询错误"+e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("媒体信息列表查询错误");
        }
        return rs;
    }

    /**
     * @Title: findAll
     * @Description:  通过APPKEY 和关键字查询广告位信息列表
     * @author xavier
     * @date 2018年3月14日
     */
    @RequestMapping(value = "/findPositionAll2", method = RequestMethod.GET)
    public ResultModel<List<InfoPositionMsgDto>> findPositionAll(String appKeys,String keyWords) {
        ResultModel<List<InfoPositionMsgDto>> rs = new ResultModel<List<InfoPositionMsgDto>>();
        try {
            Map<String,Object> params= new HashMap<>();
            if (!StringUtils.isEmpty(appKeys)) {
                String[] appKeysArray = appKeys.split(",");
                params.put("appKeysArray",appKeysArray);
            }   params.put("keyWords",keyWords);
            rs.setReturnValue(mediaPositionService.findPositionAll(params));
        } catch (Exception e) {
            logger.error("广告位信息列表查询错误"+e.getMessage(), e);
            rs.setSuccessed(false);
            rs.setErrorDesc("广告位信息列表查询错误");
        }
        return rs;
    }
}
