package com.bxm.report.web.common;

import com.alibaba.fastjson.JSONObject;

import com.bxm.report.model.constant.TicketConstant;
import com.bxm.report.model.dao.tbltag.TblAdPostionTag;
import com.bxm.report.model.vo.tbltag.TblAdTagDropdownBoxVo;
import com.bxm.report.model.vo.tbltag.TblAdTagVo;
import com.bxm.report.service.tbltag.TblAdTagService;
import com.bxm.report.service.utils.CollectionDataCopyUtil;
import com.bxm.report.web.base.BaseController;
import com.bxm.util.dto.ResultModel;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;

/**
 * @author gaoshihao
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.web.controller.tbladtag.TblAdTagController.java
 * @CopyRright (c) 2018-微财科技有限公司
 * @created 2018-04-25 20:04:00
 * @modifier ganquan
 * @updated 2018-04-25 20:04:00
 */
@RestController
@RequestMapping("tbladtag/")
public class TblAdTagController extends BaseController {

    private Logger log = LoggerFactory.getLogger(TblAdTagController.class);

    @Autowired
    private TblAdTagService tblAdTagService;

    /**
     * 根据类型标签列表（带子集合）
     * 
     * @param parentId
     * @param type
     * @return
     */
    @RequestMapping(value = "find/tblAdTagByType", method = RequestMethod.GET)
    public ResultModel<List<TblAdTagVo>> findTblAdTagListByType(@RequestParam(value = "parentId") Integer parentId,
                                                                @RequestParam(value = "type") Integer type) {

        ResultModel<List<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(tblAdTagService.findTblAdTagListByType(parentId, type));
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }

        return resultModel;
    }

    /**
     * 根据 父 id 查询列表
     * 
     * @return
     */
    @RequestMapping(value = "find/tblAdTagByParentId")
    public ResultModel<List<TblAdTagVo>> findTblAdTagByParentId(@RequestParam(value = "id") Integer id) {
        ResultModel<List<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(tblAdTagService.findTblAdTagById(id));
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }





    /**
     * 根据 id/name 返回 子标签
     * 
     * @param param
     * @param type
     * @return
     */
    @RequestMapping(value = "find/TblAdTagListByParam", method = RequestMethod.GET)
    public ResultModel<PageInfo<TblAdTagVo>> findTblAdTagListByParam(@RequestParam(value = "param", defaultValue = "") String param,
                                                                     @RequestParam(value = "type", defaultValue = "") String type,
                                                                     @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                                     @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {
        ResultModel<PageInfo<TblAdTagVo>> resultModel = new ResultModel<>();
        PageHelper.startPage(pageNum, pageSize);
        try {
            resultModel.setReturnValue(tblAdTagService.findfindTblAdTagByNameAndID(param, type));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }

        return resultModel;
    }

    /**
     * 查询所有 标签
     * 
     * @param pageNum
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "find/TblTagAll")
    public ResultModel<PageInfo<TblAdTagVo>> findAllTblTag(@RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                           @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
                                                           @RequestParam(value = "name", defaultValue = "") String name) {
        ResultModel<PageInfo<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            PageInfo<TblAdTagVo> list = tblAdTagService.findAll(pageNum, pageSize, name);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue(list);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }

    /**
     * 根据 code 查询标签列表
     * 
     * @return
     */
    @RequestMapping(value = "find/TblTagByCodeStr", method = RequestMethod.GET)
    public ResultModel<JSONObject> findTblTagByCodeStr(@RequestParam("codeStr") String codeStr) {
        ResultModel<JSONObject> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(tblAdTagService.findTblAdTagByCodeStr(codeStr));
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }

    /**
     * 根据 code 查询标签列表
     * 
     * @return
     */
    @RequestMapping(value = "find/tblTagByFirstCode", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<List<TblAdTagVo>> tblTagByFirstCode() {
        ResultModel<List<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            resultModel.setReturnValue(tblAdTagService.tblTagByFirstCode());
            resultModel.setSuccessed(true);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }

    /**
     * 根据类型标签列表（分页）
     * 
     * @param parentId
     * @param type（1属性 2 分类 3广告主）
     * @return
     */
    @RequestMapping(value = "find/findNewTreeAll", method = RequestMethod.GET, produces = "application/json")
    public ResultModel<PageInfo<TblAdTagVo>> findNewTreeAll(@RequestParam(value = "parentId", defaultValue = "0") Integer parentId,
                                                            @RequestParam(value = "type",defaultValue = "1") Integer type,
                                                            @RequestParam(value = "name", defaultValue = "") String name,
                                                            @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                            @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {

        ResultModel<PageInfo<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            PageInfo<TblAdTagVo> pag = tblAdTagService.findNewTreeAll(pageNum, pageSize, type, name, parentId);
            resultModel.setReturnValue(pag);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }

        return resultModel;
    }
    
    /**
     * 查询所有 标签
     * 
     * @param pageNum
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "find/findNewAll")
    public ResultModel<PageInfo<TblAdTagVo>> findNewAll(@RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                        @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
                                                        @RequestParam(value = "name", defaultValue = "") String name,
                                                        @RequestParam(value = "type",defaultValue = "1") Integer type) {
        ResultModel<PageInfo<TblAdTagVo>> resultModel = new ResultModel<>();
        try {
            PageInfo<TblAdTagVo> list = tblAdTagService.findNewAll(pageNum, pageSize, name,type);
            resultModel.setSuccessed(true);
            resultModel.setReturnValue(list);
        } catch (Exception e) {
            resultModel.setSuccessed(false);
            resultModel.setErrorDesc("查询出错！");
            log.error(e.getMessage(), e);
        }
        return resultModel;
    }



    /**
     * Description: 查询所以一级标签
     * JDK version used: <JDK1.8>
     * Author： hxpeng
     * Create Date： 2018/7/26 16:41
     */
    @RequestMapping(value = "findOneLevelTag")
    public ResultModel<List<TblAdTagDropdownBoxVo>> findOneLevelTag(Integer tagType){
        if (null == tagType) {
            tagType = TicketConstant.TicketTag.TAG_TYPE_CLASSIFY;
        }
        ResultModel<List<TblAdTagDropdownBoxVo>> resultModel = new ResultModel<>();
        List<TblAdPostionTag> tblAdPostionTags = tblAdTagService.findOneLevelTag(tagType);
        if (CollectionUtils.isEmpty(tblAdPostionTags)) {
            resultModel.setReturnValue(Collections.emptyList());
            return resultModel;
        }
        resultModel.setReturnValue(CollectionDataCopyUtil.copyList(tblAdPostionTags, TblAdTagDropdownBoxVo.class));
        return resultModel;
    }

}
