/*
 * Copyright 2018 bianxianmao.com All right reserved. This software is the
 * confidential and proprietary information of bianxianmao.com ("Confidential
 * Information"). You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license agreement you entered
 * into with bianxianmao.com.
 */

package com.bxm.report.web.controller;


import com.bxm.datapark.facade.activity.ActivityReportDto;
import com.bxm.report.facade.datapark.DataparkActivityPullerIntegration;
import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.constant.DataParkContens;
import com.bxm.report.model.dao.activity.ActivityCount;
import com.bxm.report.model.ro.ActivityReportRo;
import com.bxm.report.service.datapark.DataparkActivityService;
import com.bxm.util.dto.ResultModel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 活动报表，控制层
 *
 * @author 阿导是狗
 * 嗯 是的 没毛病！
 * @version v1.1.4_Report
 * @fileName com.bxm.adsmanager.web.controller.report.ActivityReportController.java
 * @CopyRright (c) 2018-杭州微财科技有限公司
 * @created 2018-02-27 11:25:00
 * @modifier 阿导是狗
 * @updated 2018-02-27 11:25:00
 */
@RestController
@RequestMapping("/activityReport")
public class ActivityReportController {


    @Autowired
    private DataparkActivityPullerIntegration dataparkActivityPullerIntegration;

    @Autowired
    private DataparkActivityService dataparkActivityService;

    /**
     * 新分页多维度查询活动报表
     * @author wuwenquan
     * @date 2018/6/17 20:04
     * @param
     * @return
     */
  @RequestMapping(value="/newActivityReport",method = RequestMethod.POST)
  public ResultModel aciticityReport( ActivityReportDto dto){
      System.out.println(dto);

ResultModel resultModel =dataparkActivityPullerIntegration.pullNewActivityData(dto);

return dataparkActivityService.pullNewActivityData(resultModel);

  }


    /*  
     * 分页查询活动报表
     * @author zhangkai  
     * @date 2018/2/27 20:04
     * @param   
     * @return   
     */ 
    @RequestMapping(value = "/activityReport", method = RequestMethod.GET)
    public ResultModel<Pagination> activityReport(ActivityReportRo activityReportRo) {
        ResultModel<Pagination> resultModel = new ResultModel<>();
        if (StringUtils.isEmpty(activityReportRo.getDatetime())) {
            resultModel.setErrorDesc("日期不能为空");
            resultModel.setSuccessed(false);
            return resultModel;
        }
        String json = dataparkActivityService.getActivityIds(activityReportRo);
        if (json == null){
            resultModel.setSuccessed(true);
            return resultModel;
        }
        resultModel = dataparkActivityPullerIntegration.pullActivityData(activityReportRo, json);
        return dataparkActivityService.pullActivityData(resultModel);
    }

    /**
     * 查询活动报表开发者维度
     * @author zhangkai
     * @date 2018/2/28 11:12
     * @param
     * @return
     */
    @RequestMapping(value = "/activityReportApp", method = RequestMethod.GET)
    public ResultModel activityReportApp(@RequestParam(required = true,  name = DataParkContens.DATETIME) String datetime,
                                         @RequestParam(required = false, name = DataParkContens.KEYWORDS) String keywords,
                                         @RequestParam(required = false, name = DataParkContens.ACTIVITY_ID) Long activityId,
                                         @RequestParam(required = false, name = DataParkContens.PAGE_SIZE) Integer pageSize,
                                         @RequestParam(required = false, name = DataParkContens.PAGE_NUM) Integer pageNum,
                                         @RequestParam(required = false, name = DataParkContens.SORT_NAME) String sortName,
                                         @RequestParam(required = false, name = DataParkContens.SORT_TYPE) String sortType){

        String json = dataparkActivityService.getAppKeys(keywords);
        if (StringUtils.isNotBlank(keywords) && StringUtils.isBlank(json)) {
            // 如果 查询条件：开发者/产品名称keywords 不为空 ，且查询结果：json为空， 那么就是没查询到开发者/产品， 这里直接返回
            ResultModel<Pagination> resultModel = new ResultModel<>();
            resultModel.setReturnValue(new Pagination());
            return resultModel;
        }
        ResultModel resultModel =  dataparkActivityPullerIntegration.activityReportApp(datetime,json,activityId,pageSize,pageNum,sortName,sortType);
        return dataparkActivityService.pullActivityAppData(resultModel);
    }


    /**
     * 查询活动报表按开发者子链接维度
     * @author zhangkai
     * @date 2018/2/28 14:37
     * @param
     * @return
     */
    @RequestMapping(value = "/activityReportAppBusiness", method = RequestMethod.GET)
    public ResultModel activityReportAppBusiness(@RequestParam(required = true,  name = DataParkContens.DATETIME) String datetime,
                                         @RequestParam(required = false, name = DataParkContens.KEYWORDS) String keywords,
                                         @RequestParam(required = false, name = DataParkContens.ACTIVITY_ID) Long activityId,
                                         @RequestParam(required = false, name = DataParkContens.APP_KEY) String appKey,
                                         @RequestParam(required = false, name = DataParkContens.PAGE_SIZE) Integer pageSize,
                                         @RequestParam(required = false, name = DataParkContens.PAGE_NUM) Integer pageNum,
                                         @RequestParam(required = false, name = DataParkContens.SORT_NAME) String sortName,
                                         @RequestParam(required = false, name = DataParkContens.SORT_TYPE) String sortType){
        String json = dataparkActivityService.getBusiness(appKey,keywords);
        if (StringUtils.isNotBlank(keywords) && StringUtils.isBlank(json)) {
            // 如果 查询条件：子链接名称keywords 不为空 ，且查询结果：json为空， 那么就是没查询到子链接， 这里直接返回
            ResultModel<Pagination> resultModel = new ResultModel<>();
            resultModel.setReturnValue(new Pagination());
            return resultModel;
        }
        ResultModel resultModel =  dataparkActivityPullerIntegration.activityReportAppBusiness(datetime,json,activityId,appKey,pageSize,pageNum,sortName,sortType);
        return dataparkActivityService.pullActivityAppBusinessData(resultModel);
    }


    /**
    * 查询活动报表按日
    * @author zhangkai
    * @date 2018/2/28 14:37
    * @param
    * @return
    */
    @RequestMapping(value = "/activityReportByDate", method = RequestMethod.GET)
    public ResultModel activityReportByDate(@RequestParam(name = DataParkContens.START_TIME) String startTime,
                                            @RequestParam(name = DataParkContens.END_TIME) String endTime,
                                            @RequestParam(name = DataParkContens.ACTIVITY_ID,required = false) Long activityId,
                                            @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                            @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType){

        List<ActivityCount> activityCounts =  dataparkActivityPullerIntegration.activityReportByDate(startTime,endTime,activityId,sortName,sortType);
        return dataparkActivityService.pullActivityByDate(activityCounts);
    }


    /**
     * 活动报表子链接按日
     * @author zhangkai
     * @date 2018/2/28 15:22
     * @param
     * @return
     */
    @RequestMapping(value = "/activityReportBusinessByDate", method = RequestMethod.GET)
    public ResultModel activityReportBusinessByDate(@RequestParam(name = DataParkContens.START_TIME) String startTime,
                                                            @RequestParam(name = DataParkContens.END_TIME) String endTime,
                                                            @RequestParam(name = DataParkContens.ACTIVITY_ID) Long activityId,
                                                            @RequestParam(name = DataParkContens.APP_KEY) String appKey,
                                                            @RequestParam(name = DataParkContens.BUSINESS) String business,
                                                            @RequestParam(name = DataParkContens.SORT_NAME, required = false) String sortName,
                                                            @RequestParam(name = DataParkContens.SORT_TYPE, required = false) String sortType){

        List<ActivityCount> activityCounts =  dataparkActivityPullerIntegration.activityReportBusinessByDate(startTime,endTime,activityId,appKey,business,sortName,sortType);
        return dataparkActivityService.pullActivityBusinessByDate(activityCounts);
    }


}
