package com.bxm.report.web.controller;

import com.bxm.report.model.base.Pagination;
import com.bxm.report.model.ro.PopupRo;
import com.bxm.report.service.activity.ActivityStatisticService;
import com.bxm.util.dto.ResultModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author yirenjie
 * createDate:  2018/10/12
 */
@RestController
@RequestMapping("/activityStatistic/popup")
@Slf4j
public class ActivityStatisticController {

    @Resource
    private ActivityStatisticService activityStatisticService;

    @GetMapping("/getList")
    public ResultModel<Pagination> getList(PopupRo popupRo){
        ResultModel<Pagination> result = new ResultModel<>();
        try {
            result.setReturnValue(activityStatisticService.getList(popupRo));
        } catch (Exception e){
            log.error("查询弹窗样式报表发生异常,请求参数:{}", popupRo, e);

        }
        return result;
    }


}
